/**
 * Project Name:goods-center-biz
 * File Name:GoodsDirectionalConfigDao.java
 * Package Name:cn.com.duiba.goods.center.biz.dao
 * Date:2016年6月28日上午11:19:39
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.dao;

import java.util.List;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.biz.entity.GoodsDirectionalConfigEntity;

/**
 * ClassName:GoodsDirectionalConfigDao <br/>
 * Date:     2016年6月28日 上午11:19:39 <br/>
 * @author   wubo
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface GoodsDirectionalConfigDao {
	/**
	 * selectById
	 * @param id
	 * @return
	 */
    public GoodsDirectionalConfigEntity selectById(Long id);
    /**
     * selectByGoods
     * @param gtype
     * @param goodsId
     * @return
     */
    public List<GoodsDirectionalConfigEntity> selectByGoods(int gtype,long goodsId);
    /**
     * selectByGoodsAndApp
     * @param gtype
     * @param goodsId
     * @param appId
     * @return
     */
    public GoodsDirectionalConfigEntity selectByGoodsAndApp(int gtype,long goodsId,long appId);
    /**
     * insert
     * @param domain
     * @return
     */
    public int insert(GoodsDirectionalConfigEntity domain);
    /**
     * update
     * @param id
     * @param dayLimit
     * @param minPrice
     * @return
     */
    public int update(long id,Integer dayLimit,Integer minPrice);
    /**
     * updateMore
     * @param id
     * @param stockId
     * @param dayLimit
     * @param minPrice
     * @return
     */
    public int updateMore(long id,Long stockId,Integer dayLimit,Integer minPrice);
    /**
     * delete
     * @param id
     * @return
     */
    public int delete(Long id);
    /**
     * selectByGoodsAll
     * @param gtype
     * @param goodss
     * @return
     */
	public List<GoodsDirectionalConfigEntity> selectByGoodsAll(GoodsTypeEnum gtype, List<Long> goodss);
}

