package cn.com.duiba.goods.center.biz.dao;

import cn.com.duiba.goods.center.biz.entity.GoodsTagsEntity;

import java.util.List;

/**
 * 
 * GoodsTagsDao
 *
 */
public interface GoodsTagsDao {

    /**
     * 新增.
     *
     * @param entity the entity
     * @return the int
     */
    int insert(GoodsTagsEntity entity);

    /**
     * 查询.
     *
     * @param gtype the gtype
     * @param gid   the gid
     * @return the GoodsTagsEntity
     */
    GoodsTagsEntity selectByGidAndGtype(Integer gtype,Long gid);

    /**
     * 根据 id 更新 tags
     *
     * @param id   the id
     * @param tags the tags
     * @return int
     */
    int updateTagsById(Long id, String tags);


    /**
     * 根据 gtype 和 gids 获取一个标签的数组
     * @param gtype
     * @param gids
     * @return
     */
    List<GoodsTagsEntity> selectByGtypeAndGids(Integer gtype, List<Long> gids);
}
