/**
 * Project Name:goods-center-biz File Name:AdvertCouponGoodsDaoImpl.java Package
 * Name:cn.com.duiba.goods.center.biz.dao.impl Date:2016年7月13日下午8:58:36 Copyright (c) 2016, duiba.com.cn All Rights
 * Reserved.
 */

package cn.com.duiba.goods.center.biz.dao.impl;

import org.springframework.stereotype.Repository;

import cn.com.duiba.goods.center.api.remoteservice.dto.AdvertCouponGoodsDto;
import cn.com.duiba.goods.center.biz.dao.AdvertCouponGoodsDao;
import cn.com.duiba.goods.center.biz.dao.BaseDao;

/**
 * ClassName:AdvertCouponGoodsDaoImpl <br/>
 * Function: 广告优惠卷DAO实现类. <br/>
 * Date: 2016年7月13日 下午8:58:36 <br/>
 * 
 * @author Administrator
 * @version
 * @since JDK 1.6
 * @see
 */
@Repository("advertCouponGoodsDao")
public class AdvertCouponGoodsDaoImpl extends BaseDao implements AdvertCouponGoodsDao {

    @Override
    public int insert(AdvertCouponGoodsDto entity) {
        return getSqlSession().insert(getStamentNameSpace("insert"), entity);
    }

    @Override
    public int update(AdvertCouponGoodsDto entity) {
        return getSqlSession().update(getStamentNameSpace("update"), entity);
    }

    @Override
    public AdvertCouponGoodsDto select(Long acgId) {
        return getSqlSession().selectOne(getStamentNameSpace("select"), acgId);
    }

    @Override
    public int delete(Long acgId) {
        return getSqlSession().delete(getStamentNameSpace("delete"), acgId);
    }

}
