/**
 * Project Name:goods-center-biz
 * File Name:PCGSellerGoodsDaoImpl.java
 * Package Name:cn.com.duiba.goods.center.biz.dao.impl
 * Date:2016年5月26日下午5:56:02
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.dao.impl;

import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.goods.center.biz.dao.BaseDao;
import cn.com.duiba.goods.center.biz.dao.PCGSellerGoodsDao;
import cn.com.duiba.goods.center.biz.entity.PCGSellerGoodsEntity;

/**
 * ClassName:PCGSellerGoodsDaoImpl <br/>
 * Date:     2016年5月26日 下午5:56:02 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Repository("pCGSellerGoodsDao")
public class PCGSellerGoodsDaoImpl extends BaseDao implements PCGSellerGoodsDao {
    @Override
    public int selectMaxPayloadBySellerId(long sellerId) {
        Map<String, Object> params=getBlankParams();
        params.put("sellerId", sellerId);
        Integer max= getSqlSession().selectOne(getStamentNameSpace("selectMaxPayloadBySellerId"),params);
        if(max==null){
            return 1;
        }
        return max;
        
    }
    @Override
    public int insertGoods2Seller(long pcgId, long sellerId,int payload) {
        Map<String, Object> params=getBlankParams();
        params.put("pcgId", pcgId);
        params.put("sellerId", sellerId);
        params.put("payload", payload);
        return getSqlSession().insert(getStamentNameSpace("insertGoods2Seller"), params);
    }

    @Override
    public int deleteGoods2Seller(long pcgId, long sellerId) {
        Map<String, Object> params=getBlankParams();
        params.put("pcgId", pcgId);
        params.put("sellerId", sellerId);
        return getSqlSession().delete(getStamentNameSpace("deleteGoods2Seller"), params);
    }

    @Override
    public int deleteSellerRelation(long sellerId) {
        Map<String, Object> params=getBlankParams();
        params.put("sellerId", sellerId);
        return getSqlSession().delete(getStamentNameSpace("deleteSellerRelation"), params);
    }

    @Override
    public int deleteGoodsRelation(long pcgId) {
        Map<String, Object> params=getBlankParams();
        params.put("pcgId", pcgId);
        return getSqlSession().delete(getStamentNameSpace("deleteGoodsRelation"), params);
    }

    @Override
    public List<PCGSellerGoodsEntity> selectBySeller(long sellerId) {
        Map<String, Object> params=getBlankParams();
        params.put("sellerId", sellerId);
        return getSqlSession().selectList(getStamentNameSpace("selectBySeller"),params);
    }

    @Override
    public List<PCGSellerGoodsEntity> selectByGoods(long pcgId) {
        Map<String, Object> params=getBlankParams();
        params.put("pcgId", pcgId);
        return getSqlSession().selectList(getStamentNameSpace("selectByGoods"),params);
    }
    
    @Override
    public int updatePayload(long sellerId,long pcgId,int payload){
        Map<String, Object> params=getBlankParams();
        params.put("pcgId", pcgId);
        params.put("sellerId", sellerId);
        params.put("payload", payload);
        return getSqlSession().update(getStamentNameSpace("updatePayload"), params);
    }
    

}

