/**
 * Project Name:goods-center-biz
 * File Name:ItemDaoImpl.java
 * Package Name:cn.com.duiba.goods.center.biz.dao.impl
 * Date:2016年6月20日上午11:37:10
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.dao.item.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Repository;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemDto;
import cn.com.duiba.goods.center.biz.dao.BaseCreditsDao;
import cn.com.duiba.goods.center.biz.dao.item.ItemDao;
import cn.com.duiba.goods.center.biz.entity.ItemEntity;

import com.alibaba.fastjson.JSONObject;

/**
 * 兑吧商品DAO
 */
@Repository("itemDao")
public class ItemDaoImpl extends BaseCreditsDao implements ItemDao{

    @Override
    public ItemEntity find(long id) {
        return getSqlSession().selectOne(getStamentNameSpace("find"),id);
    }

    @Override
    public List<ItemEntity> findLinkActivityCouponItemsByIds(List<Long> ids) {
    	if(ids.isEmpty()){
    		return new ArrayList<>();
    	}
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("ids", ids);
        return getSqlSession().selectList(getStamentNameSpace("findLinkActivityCouponItemsByIds"), paramMap);
    }

    @Override
    public List<ItemEntity> findAllByIds(List<Long> ids) {
    	if(ids.isEmpty()){
    		return new ArrayList<>();
    	}
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("ids", ids);
        return getSqlSession().selectList(getStamentNameSpace("findAllByIds"), paramMap);
    }

	@Override
	public void insert(ItemEntity itemEntity) {
		getSqlSession().insert(getStamentNameSpace("insert"), itemEntity);
	}

	@Override
	public Integer update(ItemEntity itemEntity) {
		return getSqlSession().update(getStamentNameSpace("update"), itemEntity);
	}

	@Override
	public Integer delete(Long id) {
		Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("id", id);
		return getSqlSession().update(getStamentNameSpace("delete"), paramMap);
	}

	@Override
	public Integer updateEnable(Long id, Boolean enable) {
		Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("id", id);
        paramMap.put("enable", enable);
		return getSqlSession().update(getStamentNameSpace("updateEnable"), paramMap);
	}

	@Override
	public Integer decrStock(Long id) {
		Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("id", id);
		return getSqlSession().update(getStamentNameSpace("decrStock"), paramMap);
	}

	@Override
	public Integer incrStock(Long id) {
		Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("id", id);
		return getSqlSession().update(getStamentNameSpace("incrStock"), paramMap);
	}

	@Override
	public Integer appendStock(Long id, Long number) {
		Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("id", id);
        paramMap.put("number", number);
		return getSqlSession().update(getStamentNameSpace("appendStock"), paramMap);
	}

	@Override
	public Integer deductStock(Long id, Long number) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put("id", id);
		paramMap.put("number", number);
		return getSqlSession().update(getStamentNameSpace("deductStock"), paramMap);
	}

	@Override
	public int updateRemainingAndvalidEndDate(Long itemId, Long totalStock, Date validEndDate) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put("itemId", itemId);
		paramMap.put("totalStock", totalStock);
		paramMap.put("validEndDate", validEndDate);
		return getSqlSession().update(getStamentNameSpace("updateRemainingAndvalidEndDate"), paramMap);
	}
	
	@Override
	public List<ItemDto> findHomeItems(List<Long> ids) {
		if(ids.isEmpty()){
    		return new ArrayList<>();
    	}
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put("ids", ids);
		return getSqlSession().selectList(getStamentNameSpace("findHomeItems"), paramMap);
	}

	@Override
	public ItemEntity findByType(String type) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put("type", type);
		return getSqlSession().selectOne(getStamentNameSpace("findByType"), paramMap);
	}

	@Override
	public String getJsonValue(Long id, String key) {
		String jsonText = getSqlSession().selectOne("findExtraJsonById", id);
		if (StringUtils.isBlank(jsonText)) {
			return null;
		}
		JSONObject json = JSONObject.parseObject(jsonText);
		return json.getString(key);
	}
	
	@Override
	public String findJson4Update(Long id) {
		return getSqlSession().selectOne("findJson4Update", id);
	}

	@Override
	public Integer setJsonValue(Long id, String value) {
		Map<String, Object> param = new HashMap<>();
		param.put("id", id);
		param.put("json", value);
		return getSqlSession().update("updateJson", param);
	}
}

