package cn.com.duiba.goods.center.biz.remoteservice.impl;

import java.util.Date;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemLimitDto;
import cn.com.duiba.goods.center.api.remoteservice.item.RemoteItemLimitService;
import cn.com.duiba.goods.center.biz.service.item.ItemLimitService;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * 商品兑换限制
 */
@Service
public class RemoteItemLimitServiceImpl implements RemoteItemLimitService {

	@Autowired
	private ItemLimitService itemLimitService;

	@Override
	public DubboResult<Integer> countByItemKeyAndGmtCreate(String itemKey, Date startTime) {
		Integer ret = itemLimitService.countByItemKeyAndGmtCreate(itemKey, startTime);
		return DubboResult.successResult(ret);
	}

	@Override
	public DubboResult<Void> insert(ItemLimitDto itemLimit) {
		itemLimitService.insert(itemLimit);
		return DubboResult.successResult(null);
	}

	@Override
	public DubboResult<Integer> delete(String itemKey, long consumerId, long orderId, String orderType) {
		Integer ret = itemLimitService.delete(itemKey, consumerId, orderId, orderType);
		return DubboResult.successResult(ret);
	}

}
