/**
 * Project Name:goods-center-biz
 * File Name:AdvertCouponGoodsService.java
 * Package Name:cn.com.duiba.goods.center.biz.service
 * Date:2016年7月13日下午9:22:05
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.service;

import cn.com.duiba.goods.center.api.remoteservice.dto.AdvertCouponGoodsDto;

/**
 * ClassName:AdvertCouponGoodsService <br/>
 * Function: 广告优惠卷Service. <br/>
 * Date:     2016年7月13日 下午9:22:05 <br/>
 * @author   Administrator
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface AdvertCouponGoodsService {
    
    /**
     * 新增.
     *
     * @param goods the goods
     * @return the int
     */
    boolean insert(AdvertCouponGoodsDto goods);

    /**
     * 修改.
     *
     * @param goods the goods
     * @return the int
     */
    boolean update(AdvertCouponGoodsDto goods);

    /**
     * 查询.
     *
     * @param acgId 劵码ID
     * @return the advert coupon goods entity
     */
    AdvertCouponGoodsDto select(Long acgId);

    /**
     * 删除(逻辑删除).
     *
     * @param acgId 劵码ID
     * @return the int
     */
    boolean delete(Long acgId);
}

