package cn.com.duiba.goods.center.biz.service;

import java.util.List;

import cn.com.duiba.goods.center.api.remoteservice.dto.SellerDto;


/**
 * 商家安全签名
 */
public interface SellerSevice {
	/**
	 * 新增商家安全签名
	 * 
	 * @param black
	 * @return 如果失败,返回-1
	 */
	public Boolean insertSeller(SellerDto sellerDto);

	/**
	 * 删除商家安全签名
	 * 
	 * @param id
	 * @return 如果失败,返回-1
	 * 
	 */
	public Boolean deleteSeller(Long id);

	/**
	 *
	 * @param SellerEntity
	 * @param offset
	 *            开始值
	 * @param max
	 *            每页数量
	 * @return List<SellerDto> 商家安全签名列表
	 * @return
	 */
	public List<SellerDto> findAll(SellerDto sellerDto, Integer offset, Integer max);

	/**
	 * 查询总数
	 *
	 * @param SellerDto
	 * @return Integer 总数
	 */
	public Integer findCount(SellerDto sellerDto);

	/**
	 * 通过ID返回对象
	 * 
	 * @param id
	 * @return SellerDto
	 */
	public SellerDto findById(Long id);
}
