package cn.com.duiba.goods.center.biz.service.item;

import cn.com.duiba.goods.center.biz.entity.AppItemExtraEntity;

/**
 * Created by xiaoxuda on 2016/12/6.
 */
public interface AppItemExtraService {
    /**
     * 通过appItemId查询对应商品附加信息
     * @param appItemId 非空
     * @return
     */
    AppItemExtraEntity findByAppItemId(Long appItemId);

    /**
     * 插入商品附加信息，appItemId不能为空
     * @param appItemExtra
     * @return
     */
    int insert(AppItemExtraEntity appItemExtra);

    /**
     * 通过appItemId更新对应商品附加信息，appItemId 非空
     * @param appItemExtra
     * @return
     */
    int updateByAppItemId(AppItemExtraEntity appItemExtra);

    /**
     * 通过appItemId删除对应商品附加信息
     * @param appItemId 非空
     * @return
     */
    int deleteByAppItemId(Long appItemId);

    /**
     * 插入或通过appItemId更新对应商品附加信息，appItemId 非空
     * @param appItemExtra
     * @return
     */
    int insertOrUpdateByAppItemId(AppItemExtraEntity appItemExtra);
}
