package cn.com.duiba.goods.center.biz.service.item.impl;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemExtraDto;
import cn.com.duiba.goods.center.biz.dao.item.ItemExtraDao;
import cn.com.duiba.goods.center.biz.entity.ItemExtraEntity;
import cn.com.duiba.goods.center.biz.service.item.ItemExtraService;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * Created by wenqi.huang on 2017/2/16.
 */
@Service
public class ItemExtraServiceImpl implements ItemExtraService {
    @Resource
    private ItemExtraDao itemExtraDao;

    @Override
    public ItemExtraDto findByItemId(Long itemId) {
        return BeanUtils.copy(itemExtraDao.findByItemId(itemId), ItemExtraDto.class);
    }

    @Override
    public List<ItemExtraDto> findByItemIds(List<Long> itemIds) {
        return BeanUtils.copyList(itemExtraDao.findByItemIds(itemIds), ItemExtraDto.class);
    }

    @Override
    public List<ItemExtraDto> findByName4Admin(String name) {
        return BeanUtils.copyList(itemExtraDao.findByName4Admin(name), ItemExtraDto.class);
    }

    @Override
    public List<ItemExtraDto> findAll() {
        return BeanUtils.copyList(itemExtraDao.findAll(), ItemExtraDto.class);
    }

    public int insert(ItemExtraDto itemExtra) {
        ItemExtraEntity e = BeanUtils.copy(itemExtra, ItemExtraEntity.class);
        int ret = itemExtraDao.insert(e);
        itemExtra.setId(e.getId());
        return ret;
    }

    public int update(ItemExtraDto itemExtra) {
        ItemExtraEntity e = BeanUtils.copy(itemExtra, ItemExtraEntity.class);
        return itemExtraDao.update(e);
    }
}
