/**
 * Project Name:goods-center-biz
 * File Name:IdSuffixTool.java
 * Package Name:cn.com.duiba.goods.center.biz.util
 * Date:2016年5月26日上午10:21:48
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.biz.util;


/**
 * ClassName:IdSuffixTool <br/>
 * Function: 根据id计算分表的工具 <br/>
 * Date:     2016年5月26日 上午10:21:48 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public class IdSuffixTool {
	
	private IdSuffixTool(){
		
	}
    
    /**
     * 根据id计算所属分表
     * @author xuhengfei
     * @param id
     * @return
     * @since JDK 1.6
     */
    public static String getTableSuffix(Long id){
        Long tbInt=id.longValue()%1024;
        String tb=tbInt+"";
        if(tbInt<10){
            tb="000"+tbInt;
        }else if(tbInt<100){
            tb="00"+tbInt;
        }else if(tbInt<1000){
            tb="0"+tbInt;
        }
        
        return tb;
    }

}

