/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.bo.impl;

import cn.com.duiba.goods.center.api.remoteservice.dto.AppItemClassifyRelationDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.AppItemDto;
import cn.com.duiba.goods.center.biz.bo.AppItemClassifyRelationBO;
import cn.com.duiba.goods.center.biz.dao.AppItemClassifyRelationDao;
import cn.com.duiba.goods.center.biz.dao.item.AppItemDao;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="appItemClassifyRelationBO")
public class AppItemClassifyRelationBOImpl
implements AppItemClassifyRelationBO {
    @Autowired
    private AppItemClassifyRelationDao appItemClassifyRelationDao;
    @Autowired
    private AppItemDao appItemDao;

    @Override
    public List<AppItemDto> findAppItemsWithClassifyPayLoad(Long classifyId, Long appId, String status) {
        List<AppItemClassifyRelationDto> relationList = this.appItemClassifyRelationDao.getByClassifyId(classifyId);
        if (relationList.isEmpty()) {
            return new ArrayList<AppItemDto>();
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        HashMap<Long, AppItemClassifyRelationDto> map = new HashMap<Long, AppItemClassifyRelationDto>();
        for (AppItemClassifyRelationDto dto : relationList) {
            ids.add(dto.getAppItemId());
            map.put(dto.getAppItemId(), dto);
        }
        List<AppItemDto> resultList = this.appItemDao.findAppItemsByAppIdAndIds(appId, status, ids);
        for (AppItemDto item : resultList) {
            AppItemClassifyRelationDto aicr = (AppItemClassifyRelationDto)map.get(item.getId());
            if (aicr == null) continue;
            item.setPayload(aicr.getPayload());
        }
        return resultList;
    }
}

