/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.bo.impl;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemKeyDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.PriceDegreeDto;
import cn.com.duiba.goods.center.biz.bo.CreditsCalculateBo;
import cn.com.duiba.goods.center.biz.entity.ItemEntity;
import cn.com.duiba.goods.center.biz.service.item.PreStockService;
import cn.com.duiba.goods.center.common.ErrorCode;
import cn.com.duiba.goods.center.common.RuntimeGoodsException;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CreditsCalculateBoImpl
implements CreditsCalculateBo {
    @Autowired
    private PreStockService preStockService;

    @Override
    public Long calculateCreditsByItemKeyAndDegree(ItemKeyDto key, String degree, Long appRate) {
        if ("fake".equals(key.getItemDtoType())) {
            boolean custom;
            boolean bl = custom = key.getAppItem() != null && key.getAppItem().getCustomPrice() != null && key.getAppItem().getCustomPrice().contains("duiba");
            if (custom) {
                if (key.getAppItem().isOpTypeAppItem(16)) {
                    return key.getAppItem().getCredits();
                }
                return this.getCreditsRate(key.getAppItem().getCredits(), appRate);
            }
        }
        if (key.isItemMode()) {
            ItemEntity itemEntity;
            Integer minFacePrice;
            long credits = this.getCreditsRate((long)key.getItem().getFacePrice(), appRate);
            if (key.getItem().isOpTypeItem(10) && null != (minFacePrice = this.preStockService.getMinExchangePrice(itemEntity = (ItemEntity)BeanUtils.copy((Object)key.getItem(), ItemEntity.class), key.getAppId()))) {
                credits = this.getCreditsRate((long)minFacePrice, appRate);
            }
            if (credits < 1L) {
                credits = 1L;
            }
            return credits;
        }
        if (key.isDuibaAppItemMode()) {
            if ("phoneflow".equals(key.getItem().getType())) {
                if (degree == null) {
                    return appRate;
                }
                return Long.valueOf(degree) * appRate;
            }
            if ("alipay".equals(key.getItem().getType()) || "alipaycode".equals(key.getItem().getType()) || "alipayfast".equals(key.getItem().getType()) || "qb".equals(key.getItem().getType()) || "phonebill".equals(key.getItem().getType())) {
                if (degree == null) {
                    PriceDegreeDto pd = new PriceDegreeDto(key.getAppItem().getCustomPrice());
                    if (pd.getMinDegreeCredits() == null) {
                        return (long)pd.getMinDegreeInt().intValue() * appRate * 1L;
                    }
                    return Long.valueOf(pd.getMinDegreeCredits());
                }
                PriceDegreeDto pd = new PriceDegreeDto(key.getAppItem().getCustomPrice());
                if (pd.isDegreeExist(degree)) {
                    if (pd.getCreditsByDegree(degree) == null) {
                        return Long.valueOf(degree) * appRate;
                    }
                    return Long.valueOf(pd.getCreditsByDegree(degree));
                }
                throw new RuntimeGoodsException(ErrorCode.E0404013);
            }
            if ("coupon".equals(key.getItem().getType()) || "object".equals(key.getItem().getType()) || "phonebillDingzhi".equals(key.getItem().getType())) {
                Long credits;
                if (key.getAppItem().getCredits() != null) {
                    credits = key.getAppItem().getCredits();
                } else {
                    ItemEntity itemEntity;
                    Integer minFacePrice;
                    credits = this.getCreditsRate((long)key.getItem().getFacePrice(), appRate);
                    if (key.getItem().isOpTypeItem(10) && null != (minFacePrice = this.preStockService.getMinExchangePrice(itemEntity = (ItemEntity)BeanUtils.copy((Object)key.getItem(), ItemEntity.class), key.getAppId()))) {
                        credits = this.getCreditsRate((long)minFacePrice, appRate);
                    }
                }
                if (credits < 1L) {
                    credits = 1L;
                }
                return credits;
            }
            throw new RuntimeGoodsException(ErrorCode.E0203013);
        }
        if (key.isSelfAppItemMode()) {
            if ("virtual".equals(key.getAppItem().getType())) {
                PriceDegreeDto pd = new PriceDegreeDto(key.getAppItem().getCustomPrice());
                if (degree == null) {
                    return pd.getMinDegreeCredits() == null ? null : Long.valueOf(pd.getMinDegreeCredits());
                }
                if (pd.isDegreeExist(degree)) {
                    return Long.valueOf(pd.getCreditsByDegree(degree));
                }
                throw new RuntimeGoodsException(ErrorCode.E0404013);
            }
            return key.getAppItem().getCredits();
        }
        throw new RuntimeGoodsException(ErrorCode.E0203013);
    }

    private Long getCreditsRate(Long price, Long appRate) {
        return (long)Math.ceil((double)(price * appRate) / 100.0);
    }
}

