/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.bo.item.impl;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.dto.ACGStockDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.AppItemDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemKeyDto;
import cn.com.duiba.goods.center.api.remoteservice.tool.ItemKeyUtils;
import cn.com.duiba.goods.center.biz.bo.item.ItemKeyBo;
import cn.com.duiba.goods.center.biz.entity.AppItemEntity;
import cn.com.duiba.goods.center.biz.service.GoodsBatchService;
import cn.com.duiba.goods.center.biz.service.item.AppItemService;
import cn.com.duiba.goods.center.biz.service.item.HomeAppItemService;
import cn.com.duiba.goods.center.biz.service.item.ItemKeyService;
import cn.com.duiba.goods.center.biz.service.item.ItemService;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ItemKeyBoImpl
implements ItemKeyBo {
    @Autowired
    private HomeAppItemService homeAppItemService;
    @Autowired
    private AppItemService appItemService;
    @Autowired
    private ItemService itemService;
    @Autowired
    private GoodsBatchService goodsBatchService;
    @Autowired
    private ItemKeyService itemKeyService;

    @Override
    public List<ItemKeyDto> findHomeItemKeyCacheList(Long appId) {
        return this.findHomeItemKeyList(appId);
    }

    @Override
    public List<ItemKeyDto> findHomeItemKeyList(Long appId) {
        List<AppItemDto> appItems = this.homeAppItemService.findhomeAppItemNeed(appId);
        return this.transformAppItemList(appItems);
    }

    private void batchFindGoodsCouponStock(List<ItemKeyDto> itemKeyDtos) {
        List<ACGStockDto> stocks;
        ArrayList<Long> appItemIds = new ArrayList<Long>();
        ArrayList<Long> itemIds = new ArrayList<Long>();
        for (ItemKeyDto itemKey : itemKeyDtos) {
            if (!ItemKeyUtils.isGoodsCoupon((ItemKeyDto)itemKey)) continue;
            if (itemKey.isSelfAppItemMode()) {
                appItemIds.add(itemKey.getAppItem().getId());
                continue;
            }
            if (!itemKey.isDuibaAppItemMode() && !itemKey.isItemMode()) continue;
            itemIds.add(itemKey.getItem().getId());
        }
        HashBasedTable stockTable = HashBasedTable.create();
        if (!appItemIds.isEmpty()) {
            stocks = this.goodsBatchService.findStockByGids(GoodsTypeEnum.APP, appItemIds);
            for (ACGStockDto aCGStockDto : stocks) {
                stockTable.put((Object)GoodsTypeEnum.APP, (Object)aCGStockDto.getAcgId(), (Object)aCGStockDto.getStock());
            }
        }
        if (!itemIds.isEmpty()) {
            stocks = this.goodsBatchService.findStockByGids(GoodsTypeEnum.DUIBA, itemIds);
            for (ACGStockDto aCGStockDto : stocks) {
                stockTable.put((Object)GoodsTypeEnum.DUIBA, (Object)aCGStockDto.getAcgId(), (Object)aCGStockDto.getStock());
            }
        }
        for (ItemKeyDto itemKey : itemKeyDtos) {
            Long l;
            if (!ItemKeyUtils.isGoodsCoupon((ItemKeyDto)itemKey)) continue;
            if (itemKey.isSelfAppItemMode()) {
                Long l2 = (Long)stockTable.get((Object)GoodsTypeEnum.APP, (Object)itemKey.getAppItem().getId());
                if (l2 == null) continue;
                itemKey.getAppItem().setRemaining(Integer.valueOf(l2.intValue()));
                continue;
            }
            if (!itemKey.isDuibaAppItemMode() && !itemKey.isItemMode() || (l = (Long)stockTable.get((Object)GoodsTypeEnum.DUIBA, (Object)itemKey.getItem().getId())) == null) continue;
            itemKey.getItem().setRemaining(Integer.valueOf(l.intValue()));
        }
    }

    @Override
    public List<ItemKeyDto> transformAppItemList(List<AppItemDto> appItemList) {
        ArrayList<Long> itemIds = new ArrayList<Long>();
        for (AppItemDto appItem : appItemList) {
            if (appItem.getItemId() == null) continue;
            itemIds.add(appItem.getItemId());
        }
        HashMap<Long, ItemDto> itemId2ItemMap = new HashMap<Long, ItemDto>();
        if (!itemIds.isEmpty()) {
            List<ItemDto> items = this.itemService.findHomeItems(itemIds);
            for (ItemDto item : items) {
                itemId2ItemMap.put(item.getId(), item);
            }
        }
        ArrayList<ItemKeyDto> itemKeys = new ArrayList<ItemKeyDto>();
        for (AppItemDto appItem : appItemList) {
            if (appItem.getItemId() == null) {
                itemKeys.add(new ItemKeyDto(appItem, null, appItem.getAppId()));
                continue;
            }
            ItemDto item = (ItemDto)itemId2ItemMap.get(appItem.getItemId());
            if (item == null || !item.getEnable().booleanValue() || item.getDeleted().booleanValue()) continue;
            itemKeys.add(new ItemKeyDto(appItem, item, appItem.getAppId()));
        }
        this.batchFindGoodsCouponStock(itemKeys);
        return itemKeys;
    }

    @Override
    public List<ItemKeyDto> getBatchItemKeyByAppItemIds(List<Long> appItemIds) {
        List<AppItemEntity> list = this.appItemService.findByIds(appItemIds);
        List dtos = BeanUtils.copyList(list, AppItemDto.class);
        return this.transformAppItemList(dtos);
    }

    @Override
    public ItemKeyDto transformAppItem(AppItemDto appItem) {
        if (appItem == null) {
            return null;
        }
        ArrayList appItemDtolist = Lists.newArrayList((Object[])new AppItemDto[]{appItem});
        return this.transformAppItemList(appItemDtolist).get(0);
    }

    @Override
    public List<ItemKeyDto> transformItemList(List<ItemDto> itemDtoList) {
        ArrayList<ItemKeyDto> itemKeys = new ArrayList<ItemKeyDto>();
        for (ItemDto item : itemDtoList) {
            itemKeys.add(new ItemKeyDto(null, item));
        }
        this.batchFindGoodsCouponStock(itemKeys);
        return itemKeys;
    }

    @Override
    public ItemKeyDto transformItem(ItemDto item) {
        if (item == null) {
            return null;
        }
        ArrayList itemDtolist = Lists.newArrayList((Object[])new ItemDto[]{item});
        return this.transformItemList(itemDtolist).get(0);
    }

    @Override
    public ItemKeyDto getItemKey(Long appItemId) {
        return this.itemKeyService.findItemKey(appItemId, null, null);
    }

    @Override
    public ItemKeyDto getItemKey(Long appId, Long itemId) {
        return this.itemKeyService.findItemKey(null, itemId, appId);
    }
}

