/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.dao.impl;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.biz.dao.BaseCouponDao;
import cn.com.duiba.goods.center.biz.dao.GoodsCouponDao;
import cn.com.duiba.goods.center.biz.entity.GoodsCouponEntity;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;

@Repository(value="goodsCouponDao")
public class GoodsCouponDaoImpl
extends BaseCouponDao
implements GoodsCouponDao {
    @Override
    public int insertBatchImport(GoodsTypeEnum gtype, long gid, long goodsBatchId, List<GoodsCouponDao.CouponFormat> coupons) {
        Map<String, Object> params = this.getTb1024SuffixParamsMap(gid);
        params.put("gtype", gtype.getGtype());
        params.put("gid", gid);
        params.put("goodsBatchId", goodsBatchId);
        params.put("coupons", coupons);
        params.put("status", 0);
        return this.getSqlSession().insert(this.getStamentNameSpace("insertBatchImport"), params);
    }

    @Override
    public void insertLinkCoupon(GoodsTypeEnum gtype, long gid, long goodsBatchId, long goodsCouponId, String link) {
        Map<String, Object> params = this.getTb1024SuffixParamsMap(gid);
        params.put("gtype", gtype.getGtype());
        params.put("gid", gid);
        params.put("goodsBatchId", goodsBatchId);
        params.put("link", link);
        params.put("goodsCouponId", goodsCouponId);
        params.put("status", 0);
        this.getSqlSession().insert(this.getStamentNameSpace("insertLinkCoupon"), params);
    }

    @Override
    public void insertRepeatCoupon(GoodsTypeEnum gtype, long gid, long goodsBatchId, long goodsCouponId, String code, String password) {
        Map<String, Object> params = this.getTb1024SuffixParamsMap(gid);
        params.put("gtype", gtype.getGtype());
        params.put("gid", gid);
        params.put("goodsBatchId", goodsBatchId);
        params.put("goodsCouponId", goodsCouponId);
        params.put("code", code);
        params.put("password", password);
        params.put("status", 0);
        this.getSqlSession().insert(this.getStamentNameSpace("insertRepeatCoupon"), params);
    }

    @Override
    public GoodsCouponEntity selectByCouponId(Long goodsCouponId) {
        Map<String, Object> params = this.getTb1024ByLast4Number(goodsCouponId);
        params.put("goodsCouponId", goodsCouponId);
        return (GoodsCouponEntity)this.getSqlSession().selectOne(this.getStamentNameSpace("selectByCouponId"), params);
    }

    public int selectCountByBatch(GoodsTypeEnum gtype, long gid, long goodsBatchId) {
        Map<String, Object> params = this.getTb1024SuffixParamsMap(gid);
        params.put("gtype", gtype.getGtype());
        params.put("gid", gid);
        params.put("goodsBatchId", goodsBatchId);
        return (Integer)this.getSqlSession().selectOne(this.getStamentNameSpace("selectCountByBatch"), params);
    }

    @Override
    public int selectCountByBatchNotUsed(GoodsTypeEnum gtype, long gid, long goodsBatchId) {
        Map<String, Object> params = this.getTb1024SuffixParamsMap(gid);
        params.put("gtype", gtype.getGtype());
        params.put("gid", gid);
        params.put("goodsBatchId", goodsBatchId);
        return (Integer)this.getSqlSession().selectOne(this.getStamentNameSpace("selectCountByBatchNotUsed"), params);
    }

    @Override
    public List<GoodsCouponEntity> selectPageByBatchId(GoodsTypeEnum gtype, long gid, long goodsBatchId, int start, int limit) {
        Map<String, Object> params = this.getTb1024SuffixParamsMap(gid);
        params.put("gtype", gtype.getGtype());
        params.put("gid", gid);
        params.put("goodsBatchId", goodsBatchId);
        params.put("start", start);
        params.put("limit", limit);
        return this.getSqlSession().selectList(this.getStamentNameSpace("selectPageByBatchId"), params);
    }

    @Override
    public List<GoodsCouponEntity> selectPageByBatchIdAndStatus(GoodsTypeEnum gtype, long gid, long batchId, int status, int start, int limit) {
        Map<String, Object> params = this.getTb1024SuffixParamsMap(gid);
        params.put("gtype", gtype.getGtype());
        params.put("gid", gid);
        params.put("goodsBatchId", batchId);
        params.put("status", status);
        params.put("start", start);
        params.put("limit", limit);
        return this.getSqlSession().selectList(this.getStamentNameSpace("selectPageByBatchIdAndStatus"), params);
    }

    @Override
    public List<GoodsCouponEntity> selectBatchNotUsed(GoodsTypeEnum gtype, long gid, long goodsBatchId, int limit) {
        Map<String, Object> params = this.getTb1024SuffixParamsMap(gid);
        params.put("gtype", gtype.getGtype());
        params.put("gid", gid);
        params.put("goodsBatchId", goodsBatchId);
        params.put("limit", limit);
        return this.getSqlSession().selectList(this.getStamentNameSpace("selectBatchNotUsed"), params);
    }

    @Override
    public GoodsCouponEntity selectOneCouponNotUsed(GoodsTypeEnum gtype, long gid, long goodsBatchId) {
        Map<String, Object> params = this.getTb1024SuffixParamsMap(gid);
        params.put("gtype", gtype.getGtype());
        params.put("gid", gid);
        params.put("goodsBatchId", goodsBatchId);
        return (GoodsCouponEntity)this.getSqlSession().selectOne(this.getStamentNameSpace("selectOneCouponNotUsed"), params);
    }

    @Override
    public int updateCouponMarkLocked(GoodsTypeEnum gtype, long gid, long goodsBatchId, long goodsCouponId, long consumerId) {
        Map<String, Object> params = this.getTb1024SuffixParamsMap(gid);
        params.put("gtype", gtype.getGtype());
        params.put("gid", gid);
        params.put("goodsBatchId", goodsBatchId);
        params.put("goodsCouponId", goodsCouponId);
        params.put("consumerId", consumerId);
        return this.getSqlSession().update(this.getStamentNameSpace("updateCouponMarkLocked"), params);
    }

    @Override
    public int updateCouponMarkRollback(long goodsCouponId) {
        Map<String, Object> params = this.getTb1024ByLast4Number(goodsCouponId);
        params.put("goodsCouponId", goodsCouponId);
        return this.getSqlSession().update(this.getStamentNameSpace("updateCouponMarkRollback"), params);
    }

    @Override
    public int updateCoupnoMarkUsed(long goodsCouponId, Long orderId) {
        Map<String, Object> params = this.getTb1024ByLast4Number(goodsCouponId);
        params.put("goodsCouponId", goodsCouponId);
        params.put("orderId", orderId);
        return this.getSqlSession().update(this.getStamentNameSpace("updateCoupnoMarkUsed"), params);
    }

    @Override
    public int updateLinkCoupon(GoodsTypeEnum gtype, long gid, long goodsBatchId, String link) {
        Map<String, Object> params = this.getTb1024SuffixParamsMap(gid);
        params.put("gtype", gtype.getGtype());
        params.put("gid", gid);
        params.put("goodsBatchId", goodsBatchId);
        params.put("link", link);
        return this.getSqlSession().update(this.getStamentNameSpace("updateLinkCoupon"), params);
    }

    @Override
    public int updateRepeatCoupon(GoodsTypeEnum gtype, long gid, long goodsBatchId, String code, String password) {
        Map<String, Object> params = this.getTb1024SuffixParamsMap(gid);
        params.put("gtype", gtype.getGtype());
        params.put("gid", gid);
        params.put("goodsBatchId", goodsBatchId);
        params.put("code", code);
        params.put("password", password);
        return this.getSqlSession().update(this.getStamentNameSpace("updateRepeatCoupon"), params);
    }

    @Override
    public GoodsCouponEntity selectOneByGoodsBatchId(GoodsTypeEnum gtype, long gid, long goodsBatchId) {
        Map<String, Object> params = this.getTb1024SuffixParamsMap(gid);
        params.put("gtype", gtype.getGtype());
        params.put("gid", gid);
        params.put("goodsBatchId", goodsBatchId);
        return (GoodsCouponEntity)this.getSqlSession().selectOne(this.getStamentNameSpace("selectOneByGoodsBatchId"), params);
    }

    @Override
    public List<GoodsCouponEntity> selectSearchByCode(GoodsTypeEnum gtype, long gid, long goodsBatchId, String code) {
        Map<String, Object> params = this.getTb1024SuffixParamsMap(gid);
        params.put("gtype", gtype.getGtype());
        params.put("gid", gid);
        params.put("goodsBatchId", goodsBatchId);
        params.put("code", code);
        return this.getSqlSession().selectList(this.getStamentNameSpace("selectSearchByCode"), params);
    }

    @Override
    public int deleteBatchUnusedCoupons(Integer gtype, Long gid, Long batchId) {
        Map<String, Object> params = this.getTb1024SuffixParamsMap(gid);
        params.put("gtype", gtype);
        params.put("gid", gid);
        params.put("goodsBatchId", batchId);
        return this.getSqlSession().delete(this.getStamentNameSpace("deleteBatchUnusedCoupons"), params);
    }

    @Override
    public int deleteUnusedCoupon(Integer gtype, Long gid, Long couponId) {
        Map<String, Object> params = this.getTb1024SuffixParamsMap(gid);
        params.put("gtype", gtype);
        params.put("gid", gid);
        params.put("couponId", couponId);
        return this.getSqlSession().delete(this.getStamentNameSpace("deleteUnusedCoupon"), params);
    }

    @Override
    public Long selectByBatchExistUsed(Integer gtype, long gid, long goodsBatchId) {
        Map<String, Object> params = this.getTb1024SuffixParamsMap(gid);
        params.put("gtype", gtype);
        params.put("gid", gid);
        params.put("goodsBatchId", goodsBatchId);
        return (Long)this.getSqlSession().selectOne(this.getStamentNameSpace("selectByBatchExistUsed"), params);
    }

    @Override
    public int deleteBatchUnusedCouponsByIds(Integer gtype, Long gid, Long batchId, List<Long> couponIds) {
        Map<String, Object> params = this.getTb1024SuffixParamsMap(gid);
        params.put("gtype", gtype);
        params.put("gid", gid);
        params.put("goodsBatchId", batchId);
        params.put("couponIds", couponIds);
        return this.getSqlSession().delete(this.getStamentNameSpace("deleteBatchUnusedCouponsByIds"), params);
    }

    @Override
    public List<GoodsCouponEntity> findUnusedCoupons(Integer gtype, long gid, long goodsBatchId, int limit) {
        Map<String, Object> params = this.getTb1024SuffixParamsMap(gid);
        params.put("gtype", gtype);
        params.put("gid", gid);
        params.put("goodsBatchId", goodsBatchId);
        params.put("limit", limit);
        return this.getSqlSession().selectList(this.getStamentNameSpace("findUnusedCoupons"), params);
    }

    @Override
    public int deleteGoodsCoupon(GoodsTypeEnum gtype, long gid, long batchId) {
        Map<String, Object> params = this.getTb1024SuffixParamsMap(gid);
        params.put("gtype", gtype.getGtype());
        params.put("gid", gid);
        params.put("batchId", batchId);
        return this.getSqlSession().delete(this.getStamentNameSpace("deleteGoodsCoupon"), params);
    }

    @Override
    public int deleteGoodsCouponByIds(long gid, List<Long> ids) {
        Map<String, Object> params = this.getTb1024SuffixParamsMap(gid);
        params.put("ids", ids);
        return this.getSqlSession().delete(this.getStamentNameSpace("deleteGoodsCouponByIds"), params);
    }

    @Override
    public int updateAdvertCouponMarkUsed(long goodsCouponId, Long cid, Long bizId) {
        Map<String, Object> params = this.getTb1024ByLast4Number(goodsCouponId);
        params.put("goodsCouponId", goodsCouponId);
        params.put("cid", cid);
        params.put("bizId", bizId);
        return this.getSqlSession().update(this.getStamentNameSpace("updateAdvertCouponMarkUsed"), params);
    }
}

