/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.remoteservice.impl;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemKeyDto;
import cn.com.duiba.goods.center.api.remoteservice.front.RemoteEverydayLimitService;
import cn.com.duiba.goods.center.biz.service.item.EverydayLimitService;
import cn.com.duiba.goods.center.common.ErrorCode;
import cn.com.duiba.goods.center.common.GoodsException;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="remoteEverydayLimitService")
public class RemoteEverydayLimitServiceImpl
implements RemoteEverydayLimitService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteEverydayLimitServiceImpl.class);
    @Autowired
    private EverydayLimitService everydayLimitService;

    public DubboResult<Boolean> everydayLimitCheck(Long appItemId, Long itemId, int limit) {
        try {
            boolean ret = this.everydayLimitService.updateEverydaySales(appItemId, itemId, limit);
            return DubboResult.successResult((Object)ret);
        }
        catch (GoodsException e) {
            if (ErrorCode.E0404011.getErrorCode().equals(e.getResultCode())) {
                LOGGER.warn("everydayLimitCheck" + e.getMessage());
                return DubboResult.successResult((Object)false);
            }
            LOGGER.warn("everydayLimitCheck", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Void> rollbackEverydayLimit(Long appItemId, Long itemId) {
        this.everydayLimitService.rollbackEverydayLimit(appItemId, itemId);
        return DubboResult.successResult(null);
    }

    public DubboResult<Integer> findEverydayLimitSales(Long appItemId, Long itemId) {
        Integer ret = this.everydayLimitService.findEverydayLimitSales(appItemId, itemId);
        return DubboResult.successResult((Object)ret);
    }

    public DubboResult<Long> findEverydayLimitStock(ItemKeyDto itemKeyDto) {
        Long ret = this.everydayLimitService.findEverydayStock(itemKeyDto);
        if (ret == null) {
            return DubboResult.failResult((String)"\u4e0d\u662f\u6bcf\u65e5\u9650\u91cf\u5546\u54c1\u6216\u662f\u6bcf\u65e5\u9650\u5236\u5546\u54c1\u9650\u5236\u6570\u4e3a\u7a7a");
        }
        return DubboResult.successResult((Object)ret);
    }

    public DubboResult<Boolean> decrEverydayLimitStock(ItemKeyDto itemKeyDto) {
        try {
            Boolean ret = this.everydayLimitService.decrEeverydayStock(itemKeyDto);
            if (ret == null) {
                return DubboResult.failResult((String)"\u4e0d\u662f\u6bcf\u65e5\u9650\u91cf\u5546\u54c1\u6216\u662f\u6bcf\u65e5\u9650\u5236\u5546\u54c1\u9650\u5236\u6570\u4e3a\u7a7a");
            }
            return DubboResult.successResult((Object)ret);
        }
        catch (GoodsException e) {
            if (ErrorCode.E0404011.getErrorCode().equals(e.getResultCode())) {
                LOGGER.warn("decrEverydayLimitStock" + e.getMessage());
                return DubboResult.failResult((String)e.getMessage());
            }
            LOGGER.warn("decrEverydayLimitStock", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }
}

