/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.remoteservice.impl;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemKeyDto;
import cn.com.duiba.goods.center.api.remoteservice.front.RemoteGoodsItemLimitService;
import cn.com.duiba.goods.center.biz.service.item.EverydayLimitService;
import cn.com.duiba.goods.center.common.ErrorCode;
import cn.com.duiba.goods.center.common.GoodsException;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="remoteGoodsItemLimitService")
public class RemoteGoodsItemLimitServiceImpl
implements RemoteGoodsItemLimitService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteGoodsItemLimitServiceImpl.class);
    @Autowired
    private EverydayLimitService everydayLimitService;

    public DubboResult<Boolean> addQuantityLimitCounter(ItemKeyDto itemKey) {
        try {
            Boolean result = this.everydayLimitService.decrEeverydayStock(itemKey);
            return DubboResult.successResult((Object)result);
        }
        catch (GoodsException e) {
            if (ErrorCode.E0404011.getErrorCode().equals(e.getResultCode())) {
                LOGGER.warn("addQuantityLimitCounter" + e.getMessage());
                return DubboResult.successResult((Object)false);
            }
            LOGGER.error("addQuantityLimitCounter error, ", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> subQuantityLimitCounter(ItemKeyDto itemKey) {
        try {
            Boolean result = this.everydayLimitService.incrEverydayStock(itemKey);
            return DubboResult.successResult((Object)result);
        }
        catch (Exception e) {
            LOGGER.error("subQuantityLimitCounter error, ", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }
}

