/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.remoteservice.item;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.AppItemDto;
import cn.com.duiba.goods.center.api.remoteservice.item.RemoteAppItemGoodsService;
import cn.com.duiba.goods.center.biz.entity.AppItemEntity;
import cn.com.duiba.goods.center.biz.service.item.AppItemService;
import cn.com.duiba.goods.center.biz.service.item.HomeAppItemService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.BeanUtils;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RemoteAppItemGoodsServiceImpl
implements RemoteAppItemGoodsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteAppItemGoodsServiceImpl.class);
    @Autowired
    private AppItemService appItemService;
    @Autowired
    private HomeAppItemService homeAppItemService;

    public DubboResult<AppItemDto> find(Long id) {
        try {
            AppItemEntity entity = this.appItemService.find(id);
            AppItemDto dto = (AppItemDto)BeanUtils.copy((Object)entity, AppItemDto.class);
            return DubboResult.successResult((Object)dto);
        }
        catch (Exception e) {
            LOGGER.error("find:" + id, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<AppItemDto>> findByIds(List<Long> ids) {
        try {
            List<AppItemEntity> entitys = this.appItemService.findByIds(ids);
            List dtos = BeanUtils.copyList(entitys, AppItemDto.class);
            return DubboResult.successResult((Object)dtos);
        }
        catch (Exception e) {
            LOGGER.error("findByIds:", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<AppItemDto> findByAppAndItem(Long appId, Long itemId) {
        try {
            AppItemEntity entity = this.appItemService.findByAppIdAndItemId(appId, itemId);
            AppItemDto dto = (AppItemDto)BeanUtils.copy((Object)entity, AppItemDto.class);
            return DubboResult.successResult((Object)dto);
        }
        catch (Exception e) {
            LOGGER.error("findByAppAndItem:appId=" + appId + " itemId=" + itemId, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<AppItemDto> findByAppAndItemOnline(Long appId, Long itemId) {
        try {
            AppItemEntity entity = this.appItemService.findByAppIdAndItemId(appId, itemId);
            if (entity == null || entity.getDeleted().booleanValue() || !"on".equals(entity.getStatus())) {
                return DubboResult.successResult(null);
            }
            AppItemDto dto = (AppItemDto)BeanUtils.copy((Object)entity, AppItemDto.class);
            return DubboResult.successResult((Object)dto);
        }
        catch (Exception e) {
            LOGGER.error("findByAppAndItem:appId=" + appId + " itemId=" + itemId, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Long> insert(AppItemDto appItemDto) {
        try {
            AppItemEntity entity = (AppItemEntity)BeanUtils.copy((Object)appItemDto, AppItemEntity.class);
            Long id = this.appItemService.insert(entity);
            return DubboResult.successResult((Object)id);
        }
        catch (Exception e) {
            LOGGER.error("insert:", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> update(AppItemDto appItemDto) {
        try {
            AppItemEntity entity = (AppItemEntity)BeanUtils.copy((Object)appItemDto, AppItemEntity.class);
            Boolean ret = this.appItemService.update(entity);
            return DubboResult.successResult((Object)ret);
        }
        catch (Exception e) {
            LOGGER.error("update:", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> delete(Long appId, Long appItemId) {
        try {
            Boolean ret = this.appItemService.delete(appId, appItemId);
            return DubboResult.successResult((Object)ret);
        }
        catch (Exception e) {
            LOGGER.error("update:", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Integer> deleteByIds(Long appId, List<Long> appItemIds) {
        try {
            Integer ret = this.appItemService.deleteByIds(appId, appItemIds);
            return DubboResult.successResult((Object)ret);
        }
        catch (Exception e) {
            LOGGER.error("deleteByIds:", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> updateStatus(Long appId, Long appItemId, String status) {
        try {
            Boolean ret = this.appItemService.updateStatus(appId, appItemId, status);
            return DubboResult.successResult((Object)ret);
        }
        catch (Exception e) {
            LOGGER.error("updateStatus:", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Integer> updateStatusByIds(Long appId, List<Long> appItemIds, String status) {
        try {
            Integer ret = this.appItemService.updateStatusByIds(appId, appItemIds, status);
            return DubboResult.successResult((Object)ret);
        }
        catch (Exception e) {
            LOGGER.error("updateStatusByIds:", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> appendStock(Long appId, Long appItemId, Long number) {
        try {
            Boolean ret = this.appItemService.appendStock(appId, appItemId, number);
            return DubboResult.successResult((Object)ret);
        }
        catch (Exception e) {
            LOGGER.error("appendStock:appId=" + appId + " appItemId=" + appItemId + " number=" + number, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> deductStock(Long appId, Long appItemId, Long number) {
        try {
            Boolean ret = this.appItemService.deductStock(appId, appItemId, number);
            return DubboResult.successResult((Object)ret);
        }
        catch (Exception e) {
            LOGGER.error("deductStock:appId=" + appId + " appItemId=" + appItemId + " number=" + number, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Integer> updateStatusByActivityIds(String status, Boolean delete, List<Long> oids) {
        try {
            Integer ret = this.appItemService.updateStatusByActivityIds(status, delete, oids);
            return DubboResult.successResult((Object)ret);
        }
        catch (Exception e) {
            LOGGER.error("deductStock:status=" + status + " delete=" + delete + " oids=" + oids, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<AppItemDto>> findBannerIconAppItemByCache(Long appId, List<Long> appItems) {
        List<AppItemDto> ret = this.homeAppItemService.findBannerIconAppItemByCache(appId, appItems);
        return DubboResult.successResult(ret);
    }

    public DubboResult<List<Long>> findIDbySourceIdsAndSourceTypes(List<Long> sourceIds, List<Integer> sourceTypes) {
        List<Long> ret = this.appItemService.findIDBySourceIdsAndSourceTypes(sourceIds, sourceTypes);
        return DubboResult.successResult(ret);
    }

    public DubboResult<List<AppItemDto>> findByLimitCache(Long appId, Map<String, Object> queryParams) {
        List<AppItemDto> ret = this.homeAppItemService.findByLimitCache(appId, queryParams);
        return DubboResult.successResult(ret);
    }
}

