/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.remoteservice.item;

import cn.com.duiba.goods.center.api.remoteservice.dto.ElasticGiftsItemShowDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemKeyDto;
import cn.com.duiba.goods.center.api.remoteservice.item.RemoteDuibaItemGoodsService;
import cn.com.duiba.goods.center.biz.bo.item.ItemAutoRecommendBo;
import cn.com.duiba.goods.center.biz.entity.ItemEntity;
import cn.com.duiba.goods.center.biz.service.item.ItemGoodsService;
import cn.com.duiba.goods.center.biz.service.item.ItemService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.BeanUtils;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RemoteDuibaItemGoodsServiceImpl
implements RemoteDuibaItemGoodsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteDuibaItemGoodsServiceImpl.class);
    @Autowired
    private ItemService itemService;
    @Autowired
    private ItemGoodsService itemGoodsService;
    @Autowired
    private ItemAutoRecommendBo itemAutoRecommendBo;

    public DubboResult<ItemDto> find(Long id) {
        try {
            ItemEntity entity = this.itemService.find(id);
            ItemDto dto = (ItemDto)BeanUtils.copy((Object)entity, ItemDto.class);
            return DubboResult.successResult((Object)dto);
        }
        catch (Exception e) {
            LOGGER.error("find:" + id, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<ItemDto>> findByIds(List<Long> ids) {
        try {
            List<ItemEntity> entitys = this.itemService.findByIds(ids);
            List dtos = BeanUtils.copyList(entitys, ItemDto.class);
            return DubboResult.successResult((Object)dtos);
        }
        catch (Exception e) {
            LOGGER.error("findByIds:", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Long> insert(ItemDto itemDto) {
        try {
            ItemEntity entity = (ItemEntity)BeanUtils.copy((Object)itemDto, ItemEntity.class);
            Long id = this.itemService.insert(entity);
            return DubboResult.successResult((Object)id);
        }
        catch (Exception e) {
            LOGGER.error("insert:", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> update(ItemDto itemDto) {
        try {
            ItemEntity entity = (ItemEntity)BeanUtils.copy((Object)itemDto, ItemEntity.class);
            Boolean ret = this.itemService.update(entity);
            return DubboResult.successResult((Object)ret);
        }
        catch (Exception e) {
            LOGGER.error("update:", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> delete(Long itemId) {
        try {
            Boolean ret = this.itemService.delete(itemId);
            return DubboResult.successResult((Object)ret);
        }
        catch (Exception e) {
            LOGGER.error("delete:", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> updateEnable(Long itemId, Boolean enable) {
        try {
            Boolean ret = this.itemService.updateEnable(itemId, enable);
            return DubboResult.successResult((Object)ret);
        }
        catch (Exception e) {
            LOGGER.error("updateEnable:", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> appendStock(Long itemId, Long number) {
        try {
            Boolean ret = this.itemService.appendStock(itemId, number);
            return DubboResult.successResult((Object)ret);
        }
        catch (Exception e) {
            LOGGER.error("appendStock:", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> deductStock(Long itemId, Long number) {
        try {
            Boolean ret = this.itemService.deductStock(itemId, number);
            return DubboResult.successResult((Object)ret);
        }
        catch (Exception e) {
            LOGGER.error("deductStock:", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<ItemDto>> findAutoRecommend(Long appId) {
        try {
            List<ItemEntity> entitys = this.itemService.findAutoRecommend(appId);
            List dtos = BeanUtils.copyList(entitys, ItemDto.class);
            return DubboResult.successResult((Object)dtos);
        }
        catch (Exception e) {
            LOGGER.error("findAutoRecommend:appId=" + appId, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<ItemKeyDto>> findAutoRecommendItemKey(Long appId) {
        try {
            List<ItemKeyDto> dtos = this.itemAutoRecommendBo.findHomeAutoRecommend(appId, 20);
            return DubboResult.successResult(dtos);
        }
        catch (Exception e) {
            LOGGER.error("findAutoRecommendItemKey:appId=" + appId, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<ItemKeyDto>> findAutoRecommendItemKey(Long appId, Integer size, Map<String, Object> query) {
        try {
            List<ItemKeyDto> dtos = this.itemAutoRecommendBo.findAutoRecommend(appId, size, query);
            return DubboResult.successResult(dtos);
        }
        catch (Exception e) {
            LOGGER.error("findAutoRecommendItemKey:appId=" + appId, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<ItemDto> findByType(String type) {
        try {
            ItemEntity entity = this.itemService.findByType(type);
            ItemDto dto = (ItemDto)BeanUtils.copy((Object)entity, ItemDto.class);
            return DubboResult.successResult((Object)dto);
        }
        catch (Exception e) {
            LOGGER.error("findByType:type=" + type, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<String> getJsonValue(Long id, String key) {
        try {
            String v = this.itemService.getJsonValue(id, key);
            return DubboResult.successResult((Object)v);
        }
        catch (Exception e) {
            LOGGER.error("getJsonValue:id=" + id + " key=" + key, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Integer> setJsonValue(Long id, String key, String value) {
        try {
            Integer v = this.itemService.setJsonValue(id, key, value);
            return DubboResult.successResult((Object)v);
        }
        catch (Exception e) {
            LOGGER.error("setJsonValue:id=" + id + " key=" + key + " value=" + value, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> checkElasticTakeOrder(Long itemId, Long appId, Long consumerId) {
        try {
            this.itemGoodsService.checkElasticTakeOrder(itemId, appId, consumerId);
            return DubboResult.successResult((Object)true);
        }
        catch (Exception e) {
            LOGGER.error("checkElasticTakeOrder ", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<ElasticGiftsItemShowDto>> getItemsByElItemIds4Mobile(List<Long> itemIds, Long appId, Long consumerId) {
        try {
            List<ElasticGiftsItemShowDto> result = this.itemGoodsService.getItemsByElItemIds4Mobile(itemIds, appId, consumerId);
            return DubboResult.successResult(result);
        }
        catch (Exception e) {
            LOGGER.error("getItemsByElItemIds ", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }
}

