/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.remoteservice.item;

import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsBatchDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsCouponDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemKeyDto;
import cn.com.duiba.goods.center.api.remoteservice.item.RemoteItemCouponGoodsService;
import cn.com.duiba.goods.center.biz.service.item.ItemCouponGoodsService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RemoteItemCouponGoodsServiceImpl
implements RemoteItemCouponGoodsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteItemCouponGoodsServiceImpl.class);
    @Autowired
    private ItemCouponGoodsService itemCouponGoodsService;

    public DubboResult<GoodsCouponDto> takeCoupon(ItemKeyDto itemKeyDto, Long consumerId, String bizNum) {
        try {
            if (itemKeyDto == null || itemKeyDto.getAppId() == null) {
                return DubboResult.failResult((String)"APPID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (consumerId == null || StringUtils.isEmpty((String)bizNum)) {
                return DubboResult.failResult((String)"\u7528\u6237ID\u6216\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            GoodsCouponDto entity = this.itemCouponGoodsService.takeCoupon(itemKeyDto, consumerId, bizNum);
            return DubboResult.successResult((Object)entity);
        }
        catch (Exception e) {
            LOGGER.error("takeCoupon:", (Throwable)e);
            return DubboResult.failResult((String)("\u53d1\u5238\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    public DubboResult<Boolean> completeCoupon(ItemKeyDto itemKeyDto, Long couponId, long orderId) {
        Boolean ret = this.itemCouponGoodsService.completeCoupon(itemKeyDto, couponId, orderId);
        return DubboResult.successResult((Object)ret);
    }

    public DubboResult<Boolean> rollbackCoupon(ItemKeyDto itemKeyDto, Long couponId, String bizNum) {
        Boolean ret = this.itemCouponGoodsService.rollbackCoupon(itemKeyDto, couponId, bizNum);
        return DubboResult.successResult((Object)ret);
    }

    public DubboResult<GoodsCouponDto> findCoupon(ItemKeyDto itemKeyDto, Long couponId) {
        GoodsCouponDto ret = this.itemCouponGoodsService.findCoupon(itemKeyDto, couponId);
        return DubboResult.successResult((Object)ret);
    }

    public DubboResult<GoodsBatchDto> findCurrentBatch(ItemKeyDto itemKeyDto) {
        GoodsBatchDto ret = this.itemCouponGoodsService.findCurrentBatch(itemKeyDto);
        return DubboResult.successResult((Object)ret);
    }

    public DubboResult<GoodsBatchDto> findCouponBatch(ItemKeyDto itemKeyDto, Long batchId) {
        GoodsBatchDto ret = this.itemCouponGoodsService.findCouponBatch(itemKeyDto, batchId);
        return DubboResult.successResult((Object)ret);
    }
}

