/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.remoteservice.item;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemKeyDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.PreStockDto;
import cn.com.duiba.goods.center.api.remoteservice.item.RemotePreStockService;
import cn.com.duiba.goods.center.biz.bo.CreditsCalculateBo;
import cn.com.duiba.goods.center.biz.entity.ItemEntity;
import cn.com.duiba.goods.center.biz.service.item.PreStockService;
import cn.com.duiba.goods.center.common.ErrorCode;
import cn.com.duiba.goods.center.common.RuntimeGoodsException;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.BeanUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RemotePreStockServiceImpl
implements RemotePreStockService {
    private static final Logger log = LoggerFactory.getLogger(RemotePreStockServiceImpl.class);
    @Autowired
    private PreStockService preStockService;
    @Autowired
    private CreditsCalculateBo creditsCalculateBo;

    public DubboResult<List<PreStockDto>> findAllPreStock(List<Long> itemIds, Long appId) {
        return DubboResult.successResult(this.preStockService.findAllPreStock(itemIds, appId));
    }

    public DubboResult<Long> calculateCreditsByItemKeyAndDegree(ItemKeyDto key, String degree, Long appRate) {
        try {
            if (key == null || key.getAppId() == null || appRate == null) {
                throw new RuntimeGoodsException(ErrorCode.E0404004);
            }
            return DubboResult.successResult((Object)this.creditsCalculateBo.calculateCreditsByItemKeyAndDegree(key, degree, appRate));
        }
        catch (RuntimeGoodsException e) {
            log.warn("calculateCreditsByItemKeyAndDegree:", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Integer> getMinExchangePrice(ItemDto item, Long appId) {
        ItemEntity itemEntity = (ItemEntity)BeanUtils.copy((Object)item, ItemEntity.class);
        Integer prePrice = this.preStockService.getMinExchangePrice(itemEntity, appId);
        return DubboResult.successResult((Object)prePrice);
    }

    public DubboResult<Integer> findPreEeverdayStock(ItemDto itemDto, Long appId) {
        ItemEntity itemEntity = (ItemEntity)BeanUtils.copy((Object)itemDto, ItemEntity.class);
        Integer stock = this.preStockService.findPreEverydayStock(itemEntity, appId);
        return DubboResult.successResult((Object)stock);
    }
}

