/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.service.impl;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.biz.entity.GoodsBatchEntity;
import cn.com.duiba.goods.center.biz.service.GoodsBatchService;
import cn.com.duiba.goods.center.biz.service.impl.GoodsBatchServiceImpl;
import cn.com.duiba.goods.center.biz.util.RedisKeyFactory;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="goodsBatchRedisService")
public class GoodsBatchRedisService
extends GoodsBatchServiceImpl
implements GoodsBatchService {
    @Override
    public boolean updateGoodsType(GoodsTypeEnum gtype, long gid, int dstType) {
        boolean ret = super.updateGoodsType(gtype, gid, dstType);
        if (ret) {
            this.clearBatchsCache(gtype, gid);
        }
        return ret;
    }

    @Override
    public Boolean physicalDeleteBatch(GoodsTypeEnum gtype, long gid, Long batchId) {
        boolean ret = super.physicalDeleteBatch(gtype, gid, batchId);
        if (ret) {
            this.clearBatchsCache(gtype, gid);
        }
        return ret;
    }

    @Override
    public List<GoodsBatchEntity> findNormalBatchs(GoodsTypeEnum gtype, long gid) {
        List<GoodsBatchEntity> batchs = this.findNotDeletedBatchs(gtype, gid);
        ArrayList<GoodsBatchEntity> ret = new ArrayList<GoodsBatchEntity>();
        Date today = new Date();
        for (GoodsBatchEntity e : batchs) {
            if (e.getEndDay().before(today)) continue;
            ret.add(e);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<GoodsBatchEntity> findNotDeletedBatchs(GoodsTypeEnum gtype, long gid) {
        try {
            DBTimeProfile.enter((String)"findNotDeletedBatchs");
            String value = this.getBatchsCache(gtype, gid);
            if (StringUtils.isEmpty((String)value)) {
                List<GoodsBatchEntity> batchs = super.findNotDeletedBatchs(gtype, gid);
                value = JSONObject.toJSONString(batchs);
                this.setBatchsCache(gtype, gid, value);
            }
            List list = JSONObject.parseArray((String)value, GoodsBatchEntity.class);
            return list;
        }
        finally {
            DBTimeProfile.release();
        }
    }

    @Override
    public Long createNormalBatch(GoodsTypeEnum gtype, long gid, Date start, Date end, Long stockId) {
        Long ret = super.createNormalBatch(gtype, gid, start, end, stockId);
        this.clearBatchsCache(gtype, gid);
        return ret;
    }

    @Override
    public Long createLinkBatch(GoodsTypeEnum gtype, long gid, Date start, Date end, Long stockId) {
        Long ret = super.createLinkBatch(gtype, gid, start, end, stockId);
        this.clearBatchsCache(gtype, gid);
        return ret;
    }

    @Override
    public Long createRepeatBatch(GoodsTypeEnum gtype, long gid, Date start, Date end, Long stockId) {
        Long ret = super.createRepeatBatch(gtype, gid, start, end, stockId);
        this.clearBatchsCache(gtype, gid);
        return ret;
    }

    @Override
    public Boolean deleteBatch(GoodsTypeEnum gtype, long gid, Long batchId) {
        Boolean ret = super.deleteBatch(gtype, gid, batchId);
        this.clearBatchsCache(gtype, gid);
        return ret;
    }

    @Override
    public void markBatchStatusNotUsed(long batchId) {
        super.markBatchStatusNotUsed(batchId);
        GoodsBatchEntity batch = super.find(batchId);
        this.clearBatchsCache(GoodsTypeEnum.getGoodsTypeEnum((int)batch.getGtype()), batch.getGid());
    }

    @Override
    public void markBatchStatusUsed(long batchId) {
        super.markBatchStatusUsed(batchId);
        GoodsBatchEntity batch = super.find(batchId);
        this.clearBatchsCache(GoodsTypeEnum.getGoodsTypeEnum((int)batch.getGtype()), batch.getGid());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markBatchStatusUsed(GoodsTypeEnum gtype, long gid, long batchId) {
        try {
            DBTimeProfile.enter((String)"markBatchStatusUsed");
            super.markBatchStatusUsed(batchId);
            this.clearBatchsCache(gtype, gid);
        }
        finally {
            DBTimeProfile.release();
        }
    }

    @Override
    public void markBatchStatusUsing(long batchId) {
        super.markBatchStatusUsing(batchId);
        GoodsBatchEntity batch = super.find(batchId);
        this.clearBatchsCache(GoodsTypeEnum.getGoodsTypeEnum((int)batch.getGtype()), batch.getGid());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markBatchStatusUsing(GoodsTypeEnum gtype, long gid, long batchId) {
        try {
            DBTimeProfile.enter((String)"markBatchStatusUsing");
            super.markBatchStatusUsing(batchId);
            this.clearBatchsCache(gtype, gid);
        }
        finally {
            DBTimeProfile.release();
        }
    }

    @Override
    public Boolean updateValidDate(GoodsTypeEnum gtype, long gid, long batchId, Date startDay, Date endDay) {
        Boolean result = super.updateValidDate(gtype, gid, batchId, startDay, endDay);
        this.clearBatchsCache(gtype, gid);
        return result;
    }

    @Override
    public GoodsBatchEntity refreshGoodsBatchs(GoodsTypeEnum gtype, long gid) {
        List<GoodsBatchEntity> normals = this.findNormalBatchs(gtype, gid);
        boolean saleout = this.isSaleout(normals);
        if (saleout) {
            return null;
        }
        this.getBatchSwitchLock(gtype, gid);
        try {
            GoodsBatchEntity goodsBatchEntity = super.refreshGoodsBatchs(gtype, gid);
            return goodsBatchEntity;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.releaseBatchSwitchLock(gtype, gid);
        }
    }

    private boolean isSaleout(List<GoodsBatchEntity> batchs) {
        boolean saleout = true;
        for (GoodsBatchEntity e : batchs) {
            boolean available = e.getStatus() == 1 || e.getStatus() == 2;
            if (!available) continue;
            saleout = false;
            break;
        }
        return saleout;
    }

    private boolean getBatchSwitchLock(GoodsTypeEnum gtype, long gid) {
        String key = this.getBatchSwitchLockKey(gtype, gid);
        return this.redisCacheService.tryGetLock(key, 5);
    }

    private void releaseBatchSwitchLock(GoodsTypeEnum gtype, long gid) {
        String key = this.getBatchSwitchLockKey(gtype, gid);
        this.redisCacheService.releaseLock(key);
    }

    private String getBatchsCache(GoodsTypeEnum gtype, long gid) {
        String key = this.getRedisBatchsKey(gtype, gid);
        String val = this.redisCacheService.get(key);
        if (StringUtils.isEmpty((String)val)) {
            return null;
        }
        return val;
    }

    private void clearBatchsCache(GoodsTypeEnum gtype, long gid) {
        String key = this.getRedisBatchsKey(gtype, gid);
        this.redisCacheService.delete(key);
    }

    private void setBatchsCache(GoodsTypeEnum gtype, long gid, String value) {
        String key = this.getRedisBatchsKey(gtype, gid);
        this.redisCacheService.set(key, value, 3600);
    }

    private String getRedisBatchsKey(GoodsTypeEnum gtype, long gid) {
        return (Object)((Object)RedisKeyFactory.K201) + String.valueOf(gtype.getGtype()) + "_" + gid;
    }

    private String getBatchSwitchLockKey(GoodsTypeEnum gtype, long gid) {
        return (Object)((Object)RedisKeyFactory.K202) + String.valueOf(gtype.getGtype()) + "_" + gid;
    }
}

