/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.service.impl;

import cn.com.duiba.goods.center.biz.service.RedisCacheService;
import cn.com.duiba.wolf.cache.AdvancedCacheClient;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class RedisCacheServiceImpl
implements RedisCacheService {
    private static Logger log = LoggerFactory.getLogger(RedisCacheServiceImpl.class);
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Resource(name="redisTemplate")
    private AdvancedCacheClient advancedCacheClient;

    @Override
    public <T> T getObject(String key) {
        try {
            return (T)this.advancedCacheClient.get(key);
        }
        catch (Exception e) {
            log.warn("getObject:key=" + key, (Throwable)e);
            return null;
        }
    }

    @Override
    public String get(String key) {
        try {
            return (String)this.stringRedisTemplate.opsForValue().get((Object)key);
        }
        catch (Exception e) {
            log.warn("get:key=" + key, (Throwable)e);
            return null;
        }
    }

    @Override
    public void setObject(String key, Object value, int seconds) {
        try {
            this.advancedCacheClient.set(key, value, seconds, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            log.warn("setObject:key=" + key, (Throwable)e);
        }
    }

    @Override
    public void set(String key, String value, int seconds) {
        try {
            this.stringRedisTemplate.opsForValue().set((Object)key, (Object)value, (long)seconds, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            log.warn("set:key=" + key, (Throwable)e);
        }
    }

    @Override
    public void delete(String key) {
        try {
            this.stringRedisTemplate.delete((Object)key);
        }
        catch (Exception e) {
            log.warn("set:key=" + key, (Throwable)e);
        }
    }

    @Override
    public boolean getLock(String key, int seconds) {
        try {
            boolean lock = this.stringRedisTemplate.opsForValue().setIfAbsent((Object)key, (Object)String.valueOf(seconds));
            if (lock) {
                this.stringRedisTemplate.expire((Object)key, (long)seconds, TimeUnit.SECONDS);
                return lock;
            }
        }
        catch (Exception e) {
            log.error("getLock:key=" + key, (Throwable)e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryGetLock(String key, int seconds) {
        try {
            DBTimeProfile.enter((String)"tryGetLock");
            for (int i = 0; i < 20; ++i) {
                boolean lock = this.stringRedisTemplate.opsForValue().setIfAbsent((Object)key, (Object)String.valueOf(seconds));
                if (lock) {
                    this.stringRedisTemplate.expire((Object)key, (long)seconds, TimeUnit.SECONDS);
                    boolean bl = lock;
                    return bl;
                }
                Thread.sleep(30L);
            }
        }
        catch (Exception e) {
            log.error("tryGetLock error", (Throwable)e);
        }
        finally {
            DBTimeProfile.release();
        }
        return false;
    }

    @Override
    public void releaseLock(String key) {
        try {
            this.stringRedisTemplate.delete((Object)key);
        }
        catch (Exception e) {
            log.warn("releaseLock error", (Throwable)e);
        }
    }

    @Override
    public String pop(String key) {
        return (String)this.stringRedisTemplate.opsForSet().pop((Object)key);
    }

    @Override
    public void addQueue(String key, String[] values, int seconds) {
        this.stringRedisTemplate.opsForSet().add((Object)key, (Object[])values);
        this.stringRedisTemplate.expire((Object)key, (long)seconds, TimeUnit.SECONDS);
    }

    @Override
    public Long getQueueSize(String key) {
        return this.stringRedisTemplate.opsForSet().size((Object)key);
    }
}

