/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.service.item.impl;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.AppItemDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemKeyDto;
import cn.com.duiba.goods.center.biz.entity.AppItemEntity;
import cn.com.duiba.goods.center.biz.entity.ItemEntity;
import cn.com.duiba.goods.center.biz.entity.PreStockPointEntity;
import cn.com.duiba.goods.center.biz.service.item.AppItemService;
import cn.com.duiba.goods.center.biz.service.item.EverydayLimitService;
import cn.com.duiba.goods.center.biz.service.item.ItemKeyService;
import cn.com.duiba.goods.center.biz.service.item.ItemKeyStockService;
import cn.com.duiba.goods.center.biz.service.item.ItemService;
import cn.com.duiba.goods.center.biz.service.item.PreStockService;
import cn.com.duiba.goods.center.biz.util.DateUtil;
import cn.com.duiba.goods.center.common.GoodsException;
import cn.com.duiba.wolf.utils.BeanUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ItemKeyServiceImpl
implements ItemKeyService {
    private static final Logger log = LoggerFactory.getLogger(ItemKeyServiceImpl.class);
    @Autowired
    private AppItemService appItemService;
    @Autowired
    private ItemService itemService;
    @Autowired
    private PreStockService preStockService;
    @Autowired
    private ItemKeyStockService itemKeyStockService;
    @Autowired
    private EverydayLimitService everydayLimitService;
    private static final String DECR_STOCK = "decr_stock";
    private static final String DECR_PRE_STOCK = "decr_pre_stock";
    private static final String DECR_APP_SPECIFY_STOCK = "decr_app_specify_stock";
    private static final String DECR_EVERDAY_STOCK = "decr_everday_stock";

    @Override
    public ItemKeyDto findItemKey(Long appItemId, Long itemId, Long appId) {
        return this.findItemKey(appItemId, itemId, appId, false);
    }

    @Override
    public ItemKeyDto findItemKeyIncludeDeleted(Long appItemId, Long itemId, Long appId) {
        return this.findItemKey(appItemId, itemId, appId, true);
    }

    private ItemKeyDto findItemKey(Long appItemId, Long itemId, Long appId, boolean includeDeleted) {
        AppItemEntity appItemEntity = null;
        ItemEntity itemEntity = null;
        if (appItemId != null) {
            appItemEntity = this.appItemService.find(appItemId);
            if (appItemEntity != null && appItemEntity.getItemId() != null) {
                itemEntity = this.itemService.find(appItemEntity.getItemId());
            }
        } else if (itemId != null) {
            itemEntity = this.itemService.find(itemId);
            appItemEntity = this.appItemService.findByAppIdAndItemId(appId, itemId);
        }
        if (!includeDeleted && appItemEntity != null && appItemEntity.getDeleted().booleanValue()) {
            appItemEntity = null;
        }
        AppItemDto appItemDto = null;
        if (appItemEntity != null) {
            appItemDto = (AppItemDto)BeanUtils.copy((Object)appItemEntity, AppItemDto.class);
        }
        ItemDto itemDto = null;
        if (itemEntity != null) {
            itemDto = (ItemDto)BeanUtils.copy((Object)itemEntity, ItemDto.class);
        }
        return new ItemKeyDto(appItemDto, itemDto, appId);
    }

    @Override
    public List<ItemKeyDto> findItemKeyByAppItemIds(List<Long> appItemIds, Long appId) {
        List<AppItemEntity> appItems = this.appItemService.findByIds(appItemIds);
        ArrayList<Long> itemIds = new ArrayList<Long>();
        for (AppItemEntity appItem : appItems) {
            if (appItem.getItemId() == null) continue;
            itemIds.add(appItem.getItemId());
        }
        Map<Long, ItemEntity> itemMap = this.itemService.findByIdsToMap(itemIds);
        ArrayList<ItemKeyDto> itemKeys = new ArrayList<ItemKeyDto>();
        for (AppItemEntity appItem : appItems) {
            AppItemDto appItemDto = (AppItemDto)BeanUtils.copy((Object)appItem, AppItemDto.class);
            if (appItem.getItemId() == null) {
                itemKeys.add(new ItemKeyDto(appItemDto, null, appId));
                continue;
            }
            ItemDto itemDto = (ItemDto)BeanUtils.copy((Object)itemMap.get(appItem.getItemId()), ItemDto.class);
            if (itemDto == null || !itemDto.getEnable().booleanValue() || itemDto.getDeleted().booleanValue()) continue;
            itemKeys.add(new ItemKeyDto(appItemDto, itemDto, appId));
        }
        return itemKeys;
    }

    @Override
    public Long findStock(ItemKeyDto itemKeyDto) {
        Long stock = 0L;
        if (itemKeyDto.isSelfAppItemMode()) {
            Long everydayStock;
            AppItemEntity entity = this.appItemService.find(itemKeyDto.getAppItem().getId());
            if (entity.getRemaining() != null) {
                stock = (long)entity.getRemaining();
            }
            if ((everydayStock = this.everydayLimitService.findEverydayStock(itemKeyDto)) != null && everydayStock <= stock) {
                stock = everydayStock;
            }
        } else if (itemKeyDto.isItemMode() || itemKeyDto.isDuibaAppItemMode()) {
            Long everydayStock;
            Long preStock;
            Long specifyStock;
            ItemEntity entity = this.itemService.find(itemKeyDto.getItem().getId());
            if (entity.getRemaining() != null) {
                stock = (long)entity.getRemaining();
            }
            if (this.itemService.isRechargeGoods(entity).booleanValue()) {
                return 1L;
            }
            if (stock != null && stock > 0L && entity.isOpTypeItem(3) && (specifyStock = this.itemService.findSpecifyRemaining(itemKeyDto.getAppId(), entity.getId())) != null && specifyStock <= stock) {
                stock = specifyStock;
            }
            if (stock != null && stock > 0L && entity.isOpTypeItem(10) && (preStock = this.preStockService.getPreStock(entity, itemKeyDto.getAppId())) != null && preStock <= stock) {
                stock = preStock;
            }
            if ((everydayStock = this.everydayLimitService.findEverydayStock(itemKeyDto)) != null && everydayStock <= stock) {
                stock = everydayStock;
            }
        }
        return stock;
    }

    @Override
    public Boolean consumeStock(ItemKeyDto itemKeyDto, String bizId, String bizSource) {
        HashMap<String, Boolean> context = new HashMap<String, Boolean>();
        try {
            if (this.everydayLimitService.isEverydayLimit(itemKeyDto).booleanValue()) {
                boolean decrEverydayStock = this.itemKeyStockService.decrEverydayStock(itemKeyDto);
                context.put(DECR_EVERDAY_STOCK, decrEverydayStock);
            }
            if (itemKeyDto.getItemDtoType().equals("object") || itemKeyDto.getItemDtoType().equals("virtual")) {
                boolean decrStock = this.itemKeyStockService.decrStock(itemKeyDto, bizId, bizSource);
                context.put(DECR_STOCK, decrStock);
            }
            if (itemKeyDto.isDuibaAppItemMode() || itemKeyDto.isItemMode()) {
                ItemEntity itemEntity = (ItemEntity)BeanUtils.copy((Object)itemKeyDto.getItem(), ItemEntity.class);
                PreStockPointEntity pointStock = this.preStockService.getPointStock(itemEntity, itemKeyDto.getAppId());
                if (pointStock != null) {
                    boolean decrPreStock = this.itemKeyStockService.decrPreStock(itemKeyDto.getAppId(), itemEntity.getId(), pointStock, bizId, bizSource);
                    context.put(DECR_PRE_STOCK, decrPreStock);
                }
                if ("object".equals(itemKeyDto.getItemDtoType()) || "coupon".equals(itemEntity.getType())) {
                    String redirectBizType = this.redirectType(bizSource);
                    boolean decrAppSpecifyStock = this.itemKeyStockService.decrAppSpecifyStock(itemKeyDto.getAppId(), itemEntity, bizId, redirectBizType);
                    context.put(DECR_APP_SPECIFY_STOCK, decrAppSpecifyStock);
                }
            }
            return true;
        }
        catch (Exception e) {
            Boolean everydayStock;
            Boolean appSpecifyStock;
            Boolean preStock;
            Long appItemId;
            Long itemId = itemKeyDto.getItem() == null ? null : itemKeyDto.getItem().getId();
            Long l = appItemId = itemKeyDto.getAppItem() == null ? null : itemKeyDto.getAppItem().getId();
            if (e instanceof GoodsException) {
                log.warn("consumeStock:appId=" + itemKeyDto.getAppId() + ":itemId=" + itemId + ":appItemId=" + appItemId + ":bizId=" + bizId + ":bizSource=" + bizSource + ":" + e.getMessage());
            } else {
                log.error("consumeStock:appId=" + itemKeyDto.getAppId() + ":itemId=" + itemId + ":appItemId=" + appItemId + ":bizId=" + bizId + ":bizSource=" + bizSource + ":", (Throwable)e);
            }
            Boolean stock = (Boolean)context.get(DECR_STOCK);
            if (stock != null && stock.booleanValue()) {
                this.itemKeyStockService.rollbackStock(bizId, bizSource);
            }
            if ((preStock = (Boolean)context.get(DECR_PRE_STOCK)) != null && stock.booleanValue()) {
                this.itemKeyStockService.rollbackPreStock(bizId);
            }
            if ((appSpecifyStock = (Boolean)context.get(DECR_APP_SPECIFY_STOCK)) != null && appSpecifyStock.booleanValue()) {
                String redirectBizType = this.redirectType(bizSource);
                this.itemKeyStockService.rollbackAppSpecifyStock(bizId, redirectBizType);
            }
            if ((everydayStock = (Boolean)context.get(DECR_EVERDAY_STOCK)) != null && everydayStock.booleanValue()) {
                this.itemKeyStockService.rollbackEverydayStock(itemKeyDto);
            }
            return false;
        }
    }

    @Override
    public Boolean rollbackStock(ItemKeyDto itemKeyDto, String bizId, String bizSource, Date bizDate) {
        if (itemKeyDto.getItemDtoType().equals("object") || itemKeyDto.getItemDtoType().equals("virtual")) {
            this.itemKeyStockService.rollbackStock(bizId, bizSource);
        }
        if (itemKeyDto.isDuibaAppItemMode() || itemKeyDto.isItemMode()) {
            ItemEntity itemEntity = this.itemService.find(itemKeyDto.getItem().getId());
            PreStockPointEntity pointStock = this.preStockService.getPointStock(itemEntity, itemKeyDto.getAppId());
            if (pointStock != null) {
                this.itemKeyStockService.rollbackPreStock(bizId);
            }
            if ("object".equals(itemKeyDto.getItemDtoType()) || "coupon".equals(itemEntity.getType())) {
                this.itemKeyStockService.rollbackAppSpecifyStock(bizId, bizSource);
            }
        }
        if (this.everydayLimitService.isEverydayLimit(itemKeyDto).booleanValue() && bizDate.after(DateUtil.getTodayZeroDate())) {
            this.itemKeyStockService.rollbackEverydayStock(itemKeyDto);
        }
        return true;
    }

    private String redirectType(String bizSource) {
        if ("normal".equals(bizSource)) {
            return "normalspecify";
        }
        if ("hdtool".equals(bizSource)) {
            return "hdtoolspecify";
        }
        if ("activity".equals(bizSource)) {
            return "activityspecify";
        }
        if ("ngame".equals(bizSource)) {
            return "ngamespecify";
        }
        if ("game".equals(bizSource)) {
            return "gamespecify";
        }
        if ("guess".equals(bizSource)) {
            return "guessspecify";
        }
        if ("question".equals(bizSource)) {
            return "questionspecify";
        }
        if ("quizz".equals(bizSource)) {
            return "quizzspecify";
        }
        if ("singlelottery".equals(bizSource)) {
            return "singlespecify";
        }
        if ("turntable".equals(bizSource)) {
            return "turntablespecify";
        }
        return "normalspecify";
    }
}

