/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.service.item.impl;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.PreStockDto;
import cn.com.duiba.goods.center.biz.dao.item.PreStockConsumeDetailDao;
import cn.com.duiba.goods.center.biz.dao.item.PreStockDao;
import cn.com.duiba.goods.center.biz.dao.item.PreStockManualChangeDao;
import cn.com.duiba.goods.center.biz.dao.item.PreStockPointDao;
import cn.com.duiba.goods.center.biz.entity.ItemEntity;
import cn.com.duiba.goods.center.biz.entity.PreStockConsumeDetailEntity;
import cn.com.duiba.goods.center.biz.entity.PreStockEntity;
import cn.com.duiba.goods.center.biz.entity.PreStockManualChangeEntity;
import cn.com.duiba.goods.center.biz.entity.PreStockPointEntity;
import cn.com.duiba.goods.center.biz.service.item.PreStockService;
import cn.com.duiba.goods.center.biz.service.stock.MemStockService;
import cn.com.duiba.goods.center.common.ErrorCode;
import cn.com.duiba.goods.center.common.GoodsException;
import cn.com.duiba.goods.center.common.RuntimeGoodsException;
import cn.com.duiba.wolf.cache.AdvancedCacheClient;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import cn.com.duiba.wolf.utils.DateUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PreStockServiceImpl
implements PreStockService {
    private static final Logger log = LoggerFactory.getLogger(PreStockServiceImpl.class);
    @Autowired
    private PreStockPointDao preStockPointDao;
    @Autowired
    private PreStockDao preStockDao;
    @Resource(name="stringRedisTemplate03")
    private AdvancedCacheClient advancedCacheClient;
    @Autowired
    private PreStockConsumeDetailDao preStockConsumeDetailDao;
    @Autowired
    private PreStockManualChangeDao preStockManualChangeDao;
    @Autowired
    private MemStockService memStockService;

    @Override
    public void consumeStock(String bizId, Long appId, Long pointId) throws GoodsException {
        PreStockEntity stock = this.preStockDao.findByPointId(pointId);
        if (null == stock) {
            throw new GoodsException(ErrorCode.E0202009);
        }
        if (stock.getStock() < 1L) {
            throw new GoodsException(ErrorCode.E0202006.getErrorCode(), "\u9884\u5206\u914d\u5e93\u5b58\u4e0d\u8db3 ");
        }
        Long preStockId = stock.getId();
        PreStockPointEntity pointStock = this.preStockPointDao.find(pointId);
        this.decrPreEverydayStock(pointStock);
        boolean success = this.preStockDao.reduceQuantity(stock.getId(), 1L);
        if (!success) {
            throw new GoodsException(ErrorCode.E0202006.getErrorCode(), "\u9884\u5206\u914d\u5e93\u5b58\u4e0d\u8db3");
        }
        PreStockConsumeDetailEntity detail = new PreStockConsumeDetailEntity();
        detail.setBizId(bizId);
        detail.setAction("pay");
        detail.setPointId(pointId);
        detail.setStockId(preStockId);
        detail.setQuantity(1L);
        detail.setAppId(appId);
        Date now = new Date(System.currentTimeMillis() / 1000L * 1000L);
        detail.setGmtCreate(now);
        detail.setGmtModified(now);
        this.preStockConsumeDetailDao.insert(detail);
        try {
            this.deletePreStockCounter(pointId);
        }
        catch (Exception e) {
            log.error(" method: deletePreStockCounter error", (Throwable)e);
        }
    }

    private void decrPreEverydayStock(PreStockPointEntity pointStock) throws GoodsException {
        boolean limit;
        if (null == pointStock) {
            return;
        }
        if (pointStock.getLimitEverydayQuantity() != null && !(limit = this.memStockService.consumeEverydayStock(pointStock.getId().toString(), pointStock.getLimitEverydayQuantity()))) {
            throw new GoodsException(ErrorCode.E0202006.getErrorCode(), "\u9884\u5206\u914d\u6bcf\u65e5\u9650\u91cf\u5e93\u5b58\u4e0d\u8db3");
        }
    }

    @Override
    public void paybackStock(String bizId) throws GoodsException {
        PreStockConsumeDetailEntity consume = this.preStockConsumeDetailDao.findByBizIdAndPayAction(bizId);
        if (consume == null) {
            return;
        }
        boolean success = this.preStockDao.addQuantity(consume.getStockId(), 1L);
        if (!success) {
            throw new GoodsException(ErrorCode.E0404011.getErrorCode(), "\u8fd4\u8fd8\u9884\u5206\u914d\u5e93\u5b58\u5931\u8d25");
        }
        PreStockConsumeDetailEntity detail = new PreStockConsumeDetailEntity();
        detail.setBizId(bizId);
        detail.setAction("back");
        detail.setPointId(consume.getPointId());
        detail.setStockId(consume.getStockId());
        detail.setQuantity(consume.getQuantity());
        detail.setAppId(consume.getAppId());
        Date now = new Date(System.currentTimeMillis() / 1000L * 1000L);
        detail.setGmtCreate(now);
        detail.setGmtModified(now);
        this.preStockConsumeDetailDao.insert(detail);
        try {
            this.deletePreStockCounter(consume.getPointId());
        }
        catch (Exception e) {
            log.error(" method: deletePreStockCounter error", (Throwable)e);
        }
    }

    @Override
    public Long getPreStock(ItemEntity itemEntity, Long appId) {
        PreStockEntity stock;
        PreStockPointEntity point = this.getPointStock(itemEntity, appId);
        if (null != point && null != (stock = this.preStockDao.findByPointId(point.getId()))) {
            return stock.getStock();
        }
        return null;
    }

    @Override
    public List<PreStockDto> findAllPreStock(List<Long> itemIds, Long appId) {
        List<PreStockPointEntity> points = this.preStockPointDao.findAllPointAppItem(itemIds, appId);
        LinkedHashMap filterMap = Maps.newLinkedHashMap();
        for (PreStockPointEntity point : points) {
            if (filterMap.containsKey(point.getItemId()) && point.getAppId() == null) continue;
            filterMap.put(point.getItemId(), point);
        }
        ArrayList pointIds = Lists.newArrayList();
        for (Map.Entry entry : filterMap.entrySet()) {
            PreStockPointEntity po = (PreStockPointEntity)entry.getValue();
            pointIds.add(po.getId());
        }
        HashMap stockMap = Maps.newHashMap();
        if (!pointIds.isEmpty()) {
            List<PreStockEntity> preStockList = this.preStockDao.findAllByPointIds(pointIds);
            for (PreStockEntity stock : preStockList) {
                stockMap.put(stock.getPointId(), stock);
            }
        }
        ArrayList returnList = Lists.newArrayList();
        for (PreStockPointEntity point : filterMap.values()) {
            PreStockDto dto = new PreStockDto();
            dto.setPointId(point.getId());
            dto.setAppId(point.getAppId());
            dto.setItemId(point.getItemId());
            dto.setLimitEverydayQuantity(point.getLimitEverydayQuantity());
            dto.setMinFacePrice(point.getMinFacePrice());
            dto.setLimitCount(point.getLimitCount());
            if (stockMap.containsKey(point.getId())) {
                dto.setStock(((PreStockEntity)stockMap.get(point.getId())).getStock());
            } else {
                dto.setStock(Long.valueOf(0L));
            }
            returnList.add(dto);
        }
        return returnList;
    }

    @Override
    public Integer findPreEverydayStock(ItemEntity entity, Long appId) {
        if (entity == null || appId == null) {
            throw new RuntimeGoodsException(ErrorCode.E0404004);
        }
        PreStockPointEntity point = this.getPointStock(entity, appId);
        if (null == point || null == point.getLimitEverydayQuantity()) {
            return null;
        }
        return this.getPreEverydayStock(point).intValue();
    }

    private Long getPreEverydayStock(PreStockPointEntity point) {
        try {
            String key = this.getKey(point.getId());
            Integer salesCount = (Integer)this.advancedCacheClient.get(key);
            if (null == salesCount) {
                Integer countNum = this.preStockConsumeDetailDao.countSalesTime(point.getId(), DateUtils.getDayDate((Date)new Date()));
                int exp = Math.min(DateUtils.getToTomorrowSeconds(), 3600);
                this.advancedCacheClient.set(key, (Object)countNum, exp, TimeUnit.SECONDS);
                salesCount = countNum;
            }
            Integer limit = point.getLimitEverydayQuantity();
            Integer remaining = 0;
            if (salesCount < limit) {
                remaining = limit - salesCount;
            }
            return (long)remaining;
        }
        catch (Exception e) {
            log.error("getPreEverydayStock", (Throwable)e);
            return 0L;
        }
    }

    @Override
    public Boolean deletePreStockCounter(Long pointId) {
        try {
            String key = this.getKey(pointId);
            this.advancedCacheClient.remove(key);
            return true;
        }
        catch (Exception e) {
            log.error(" method: deletePreStockCounter", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreStockPointEntity getPointStock(ItemEntity itemEntity, Long appId) {
        try {
            DBTimeProfile.enter((String)"getPointStock");
            if (itemEntity == null || !itemEntity.isOpTypeItem(10)) {
                PreStockPointEntity preStockPointEntity = null;
                return preStockPointEntity;
            }
            PreStockPointEntity point = this.preStockPointDao.findAppIdAndItemId(appId, itemEntity.getId());
            if (null != point) {
                PreStockPointEntity preStockPointEntity = point;
                return preStockPointEntity;
            }
            PreStockPointEntity pointShare = this.preStockPointDao.findItemIdAndNullApp(itemEntity.getId());
            if (null != pointShare) {
                PreStockPointEntity preStockPointEntity = pointShare;
                return preStockPointEntity;
            }
            PreStockPointEntity preStockPointEntity = null;
            return preStockPointEntity;
        }
        finally {
            DBTimeProfile.release();
        }
    }

    private String getKey(Long pointId) {
        return "121-" + pointId;
    }

    @Override
    public long newStock(Long pointId, Long stockNum) throws GoodsException {
        PreStockEntity old = this.preStockDao.findByPointId(pointId);
        if (old != null) {
            return old.getId();
        }
        PreStockEntity stock = new PreStockEntity();
        stock.setPointId(pointId);
        stock.setStock(stockNum);
        stock = this.preStockDao.newStock(stock);
        return stock.getId();
    }

    @Override
    public boolean addStockQuantity(Long bizId, Long pointId, Integer quantity) throws GoodsException {
        PreStockEntity stock = this.preStockDao.findByPointId(pointId);
        if (null == stock) {
            throw new GoodsException(ErrorCode.E0202009);
        }
        this.preStockDao.addQuantity(stock.getId(), quantity.intValue());
        PreStockManualChangeEntity instance = new PreStockManualChangeEntity();
        instance.setBeforeStock(stock.getStock());
        instance.setAfterStock(stock.getStock() + (long)quantity.intValue());
        instance.setChangeKind("add");
        instance.setChangeQuantity(quantity);
        instance.setStockId(stock.getId());
        instance.setBizId(bizId);
        this.preStockManualChangeDao.insert(instance);
        return true;
    }

    @Override
    public boolean reduceStockQuantity(Long bizId, Long pointId, Integer quantity) throws GoodsException {
        PreStockEntity stock = this.preStockDao.findByPointId(pointId);
        if (null == stock) {
            throw new GoodsException(ErrorCode.E0404011.getErrorCode(), "\u9884\u5206\u914d\u5e93\u5b58\u4e0d\u5b58\u5728");
        }
        if (stock.getStock() < (long)quantity.intValue()) {
            throw new GoodsException(ErrorCode.E0202006.getErrorCode(), "\u9884\u5206\u914d\u5e93\u5b58\u4e0d\u8db3");
        }
        this.preStockDao.reduceQuantity(stock.getId(), quantity.intValue());
        PreStockManualChangeEntity instance = new PreStockManualChangeEntity();
        instance.setBeforeStock(stock.getStock());
        instance.setAfterStock(stock.getStock() - (long)quantity.intValue());
        instance.setChangeKind("sub");
        instance.setChangeQuantity(quantity);
        instance.setStockId(stock.getId());
        instance.setBizId(bizId);
        this.preStockManualChangeDao.insert(instance);
        return true;
    }

    @Override
    public boolean reduceStockAll(Long bizId, Long pointId) throws GoodsException {
        PreStockEntity stock = this.preStockDao.findByPointId(pointId);
        if (null == stock) {
            throw new GoodsException(ErrorCode.E0202009);
        }
        this.preStockDao.reduceQuantity(stock.getId(), stock.getStock());
        PreStockManualChangeEntity instance = new PreStockManualChangeEntity();
        instance.setBeforeStock(stock.getStock());
        instance.setAfterStock(instance.getBeforeStock() - stock.getStock());
        instance.setChangeKind("sub");
        instance.setChangeQuantity(Integer.parseInt(stock.getStock() + ""));
        instance.setStockId(stock.getId());
        instance.setBizId(bizId);
        this.preStockManualChangeDao.insert(instance);
        return true;
    }

    @Override
    public void submitPreStock(List<PreStockPointEntity> insertPointList, List<PreStockPointEntity> updatePointList) throws GoodsException {
        if (!insertPointList.isEmpty()) {
            for (PreStockPointEntity stock : insertPointList) {
                if (null == stock.getLimitCount()) {
                    stock.setLimitCount(0);
                }
                this.preStockPointDao.insert(stock);
                this.newStock(stock.getId(), Long.parseLong(stock.getLimitCount() + ""));
            }
        }
        if (!updatePointList.isEmpty()) {
            for (PreStockPointEntity point : updatePointList) {
                this.preStockPointDao.update(point);
                if (null == point.getLimitCount()) {
                    this.reduceStockAll(point.getId(), point.getId());
                } else if (point.getLimitCount() < 0) {
                    this.reduceStockQuantity(point.getId(), point.getId(), Math.abs(point.getLimitCount()));
                } else if (point.getLimitCount() > 0) {
                    this.addStockQuantity(point.getId(), point.getId(), Math.abs(point.getLimitCount()));
                }
                this.deletePreStockCounterMem(point.getId());
            }
        }
    }

    @Override
    public Integer getMinExchangePrice(ItemEntity item, Long appId) {
        if (appId == null || item == null) {
            throw new RuntimeGoodsException(ErrorCode.E0404004);
        }
        PreStockPointEntity point = this.getPointStock(item, appId);
        if (null != point && null != point.getMinFacePrice()) {
            return point.getMinFacePrice();
        }
        return null;
    }

    private void deletePreStockCounterMem(Long pointId) {
        if (null == pointId) {
            return;
        }
        String key = this.getKey(pointId);
        this.advancedCacheClient.remove(key);
    }
}

