/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.service.stock.impl;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemAppSpecifyDto;
import cn.com.duiba.goods.center.biz.dao.item.ItemAppSpecifyDao;
import cn.com.duiba.goods.center.biz.entity.ItemAppSpecifyEntity;
import cn.com.duiba.goods.center.biz.service.stock.ItemAppSpecifyService;
import cn.com.duiba.wolf.cache.AdvancedCacheClient;
import cn.com.duiba.wolf.cache.CacheLoader;
import cn.com.duiba.wolf.utils.BeanUtils;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ItemAppSpecifyServiceImpl
implements ItemAppSpecifyService {
    @Autowired
    private ItemAppSpecifyDao itemAppSpecifyDao;
    @Resource
    private AdvancedCacheClient cacheClient;

    @Override
    public List<ItemAppSpecifyDto> findSpecifyByItemIdsAndAppId(List<Long> itemIds, Long appId) {
        if (itemIds.isEmpty()) {
            return Collections.emptyList();
        }
        List<ItemAppSpecifyEntity> list = this.itemAppSpecifyDao.findSpecifyByItemIdsAndAppId(itemIds, appId);
        return BeanUtils.copyList(list, ItemAppSpecifyDto.class);
    }

    @Override
    public ItemAppSpecifyDto findByItemIdAndAppId(final Long itemId, final Long appId) {
        return (ItemAppSpecifyDto)this.cacheClient.getWithCacheLoader(this.getCacheKeyByItemIdAndAppId(itemId, appId), 1, TimeUnit.SECONDS, true, (CacheLoader)new CacheLoader<ItemAppSpecifyDto>(){

            public ItemAppSpecifyDto load() {
                return (ItemAppSpecifyDto)BeanUtils.copy((Object)ItemAppSpecifyServiceImpl.this.itemAppSpecifyDao.findByItemIdAndAppId(itemId, appId), ItemAppSpecifyDto.class);
            }
        });
    }

    private String getCacheKeyByItemIdAndAppId(Long itemId, Long appId) {
        return "gc.itemAS_itemId_appId_" + itemId + "_" + appId;
    }
}

