/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.bo.impl;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsCouponDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.ImmediatelyButtonDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.SellerDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.TbGoodsOpenUrlDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemKeyDto;
import cn.com.duiba.goods.center.api.remoteservice.front.RemoteGoodsCouponService;
import cn.com.duiba.goods.center.biz.bo.ImmediatelyButtonBackendBo;
import cn.com.duiba.goods.center.biz.entity.ItemEntity;
import cn.com.duiba.goods.center.biz.service.SellerSevice;
import cn.com.duiba.goods.center.biz.service.TbGoodsOpenurlService;
import cn.com.duiba.goods.center.biz.service.item.ItemCouponGoodsService;
import cn.com.duiba.goods.center.biz.service.item.ItemService;
import cn.com.duiba.goods.center.common.ErrorCode;
import cn.com.duiba.goods.center.common.RuntimeGoodsException;
import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.duiba.wolf.utils.DateUtils;
import cn.com.duiba.wolf.utils.SecurityUtils;
import cn.com.duiba.wolf.utils.UrlUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ImmediatelyButtonBackendBoImpl
implements ImmediatelyButtonBackendBo {
    private static final Logger log = LoggerFactory.getLogger(ImmediatelyButtonBackendBoImpl.class);
    @Autowired
    private ItemService itemService;
    @Autowired
    private SellerSevice sellerSevice;
    @Autowired
    private ItemCouponGoodsService itemCouponGoodsService;
    @Resource
    private TbGoodsOpenurlService tbGoodsOpenurlService;
    @Autowired
    private RemoteGoodsCouponService remoteGoodsCouponService;
    private static final String MEITUAN_URL = "http://i.meituan.com/firework/";
    private static final String MEITUAN_FROM = "duiba";
    private static final String MEITUAN_SALT = "d442c590d699";
    private static final String MEITUAN_END = "&utm_source=waputm_dbjfhd&utm_medium=wap";

    @Override
    public String selectImmediatelyButtonFromItem(Long itemId, GoodsTypeEnum gtype, Long orderId, String ua, String hdtoolFalg, String urlParameter, String embedClickurl) {
        String userAgent = ua.toLowerCase();
        String returls = "";
        TbGoodsOpenUrlDto goodOpenUrl = this.tbGoodsOpenurlService.findTbGoodsOpenurl(itemId, gtype.getGtype());
        if (goodOpenUrl != null) {
            returls = "2".equals(hdtoolFalg) || goodOpenUrl.getImmediatelyButton() == 1 ? (!"2".equals(hdtoolFalg) ? "/crecord/recordDetailNew/" + orderId + "?after=1&dbnewopen" : (userAgent.contains("android") ? goodOpenUrl.getAndroidDownload() : goodOpenUrl.getIosDownload())) : (userAgent.contains("android") ? goodOpenUrl.getAndroidDownload() : goodOpenUrl.getIosDownload());
        } else if (gtype.getGtype() == 0) {
            ItemEntity item = this.itemService.find(itemId);
            if (item == null) {
                throw new RuntimeGoodsException(ErrorCode.E0404004);
            }
            returls = userAgent.contains("android") ? item.getAndroidDownload() : (item.getIosDownload() != null ? item.getIosDownload() : item.getIosOpen());
        }
        if (returls == null || returls.length() == 0) {
            returls = "";
        } else if (!(urlParameter == null || urlParameter.length() <= 0 || embedClickurl == null || embedClickurl.length() <= 0 || "1".equals(hdtoolFalg) && goodOpenUrl != null && goodOpenUrl.getImmediatelyButton() == 1)) {
            try {
                returls = embedClickurl + URLEncoder.encode(returls, "utf-8") + urlParameter;
            }
            catch (UnsupportedEncodingException e) {
                log.error("URLEncoder.encode:", (Throwable)e);
            }
        }
        return returls;
    }

    @Override
    public String selectImmediatelyButtonFromCoupon(Long couponId, Long itemId, Long orderId, String urlParameter, String embedClickurl) {
        String returls = "";
        ItemEntity item = this.itemService.find(itemId);
        if (item == null) {
            throw new RuntimeGoodsException(ErrorCode.E0404004);
        }
        ItemKeyDto itemKeyDto = new ItemKeyDto(null, (ItemDto)BeanUtils.copy((Object)item, ItemDto.class));
        GoodsCouponDto coupon = this.itemCouponGoodsService.findCoupon(itemKeyDto, couponId);
        if (coupon == null) {
            throw new RuntimeGoodsException(ErrorCode.E0404004);
        }
        returls = 1 == item.getSubType() ? coupon.getLink() : coupon.getCode();
        if (item.getSellerId() != null && item.getSellerId() != 0L) {
            StringBuilder sb = new StringBuilder();
            StringBuilder urlParam = new StringBuilder();
            if (!"".equals(returls)) {
                Map mapRequest = UrlUtils.uRLRequest((String)returls);
                for (String strRequestKey : mapRequest.keySet()) {
                    sb.append((String)mapRequest.get(strRequestKey));
                    if (urlParam.length() == 0) {
                        urlParam.append(strRequestKey + "=" + (String)mapRequest.get(strRequestKey));
                        continue;
                    }
                    urlParam.append("&" + strRequestKey + "=" + (String)mapRequest.get(strRequestKey));
                }
            }
            if (returls.contains(MEITUAN_URL)) {
                return ImmediatelyButtonBackendBoImpl.getMeituanUrl(returls, urlParameter, urlParam.toString());
            }
            if (orderId != null) {
                String timestamp = DateUtils.getMillisecond();
                sb.append(timestamp);
                sb.append(orderId);
                if (urlParam.length() == 0) {
                    urlParam.append("timestamp=" + timestamp);
                } else {
                    urlParam.append("&timestamp=" + timestamp);
                }
                urlParam.append("&orderId=" + orderId);
            }
            SellerDto result = this.sellerSevice.findById(item.getSellerId());
            returls = UrlUtils.urlPage((String)returls) + "?" + urlParam + "&sign=" + SecurityUtils.encode2StringBySHA((String)(sb.toString() + result.getSafeSign()));
        }
        if (urlParameter != null && urlParameter.length() > 0 && embedClickurl != null && embedClickurl.length() > 0) {
            try {
                returls = embedClickurl + URLEncoder.encode(returls, "utf-8") + urlParameter;
            }
            catch (UnsupportedEncodingException e) {
                log.error("URLEncoder.encode:", (Throwable)e);
            }
        }
        return returls;
    }

    private static String getMeituanUrl(String sellerUrl, String consunmerId, String urlParam) {
        String sign = SecurityUtils.encode2StringByMd5((String)(consunmerId + MEITUAN_FROM + MEITUAN_SALT)).toLowerCase().substring(0, 32);
        return UrlUtils.urlPage((String)sellerUrl) + "?code=" + consunmerId + "&sign=" + sign + "&from=" + MEITUAN_FROM + urlParam + MEITUAN_END;
    }

    @Override
    public ImmediatelyButtonDto selectImmediatelyForPlatfrom(Long gid, GoodsTypeEnum gtype, Long orderId, String ua, String hdtoolFalg, String consunmerId) {
        String userAgent = ua.toLowerCase();
        TbGoodsOpenUrlDto goodOpenUrl = this.tbGoodsOpenurlService.findTbGoodsOpenurl(gid, gtype.getGtype());
        ImmediatelyButtonDto dto = new ImmediatelyButtonDto();
        String returls = "";
        dto.setOpenUrl(Boolean.valueOf(false));
        dto.setConfirm(Boolean.valueOf(false));
        dto.setShowUse(Boolean.valueOf(false));
        if (goodOpenUrl != null) {
            if ("2".equals(hdtoolFalg) || goodOpenUrl.getImmediatelyButton() == 1) {
                if (!"2".equals(hdtoolFalg)) {
                    dto.setShowUse(Boolean.valueOf(true));
                    dto.setBtnText("\u67e5\u770b\u4f7f\u7528\u65b9\u6cd5");
                    returls = "/crecord/recordDetailNew/" + orderId + "?after=1";
                } else if (userAgent.contains("android")) {
                    if (goodOpenUrl.isOpTypeAppItem(3) && goodOpenUrl.isOpTypeAppItem(2)) {
                        dto.setConfirm(Boolean.valueOf(true));
                    } else {
                        dto.setConfirm(Boolean.valueOf(false));
                    }
                    returls = goodOpenUrl.getAndroidDownload();
                    if (returls != null && returls.length() > 0) {
                        dto.setShowUse(Boolean.valueOf(true));
                    }
                } else {
                    dto.setConfirm(Boolean.valueOf(false));
                    if (!goodOpenUrl.isOpTypeAppItem(1)) {
                        dto.setOpenUrl(Boolean.valueOf(true));
                    }
                    if ((returls = goodOpenUrl.getIosDownload()) != null && returls.length() > 0) {
                        dto.setShowUse(Boolean.valueOf(true));
                    }
                }
            } else if (userAgent.contains("android")) {
                if (goodOpenUrl.isOpTypeAppItem(3) && goodOpenUrl.isOpTypeAppItem(2)) {
                    dto.setConfirm(Boolean.valueOf(true));
                } else {
                    dto.setConfirm(Boolean.valueOf(false));
                }
                returls = goodOpenUrl.getAndroidDownload();
                if (returls != null && returls.length() > 0) {
                    dto.setShowUse(Boolean.valueOf(true));
                }
            } else {
                if (!goodOpenUrl.isOpTypeAppItem(1)) {
                    dto.setOpenUrl(Boolean.valueOf(true));
                }
                if ((returls = goodOpenUrl.getIosDownload()) != null && returls.length() > 0) {
                    dto.setShowUse(Boolean.valueOf(true));
                }
            }
        } else {
            throw new RuntimeGoodsException(ErrorCode.E0404004);
        }
        if (returls == null || returls.length() == 0) {
            returls = "";
        }
        if (returls.contains(MEITUAN_URL)) {
            StringBuilder urlParam = new StringBuilder();
            if (!"".equals(returls)) {
                Map mapRequest = UrlUtils.uRLRequest((String)returls);
                for (String strRequestKey : mapRequest.keySet()) {
                    if (urlParam.length() == 0) {
                        urlParam.append(strRequestKey + "=" + (String)mapRequest.get(strRequestKey));
                        continue;
                    }
                    urlParam.append("&" + strRequestKey + "=" + (String)mapRequest.get(strRequestKey));
                }
            }
            returls = ImmediatelyButtonBackendBoImpl.getMeituanUrl(returls, consunmerId, urlParam.toString());
        }
        dto.setSpecialApp(Boolean.valueOf(goodOpenUrl.isOpTypeAppItem(4)));
        dto.setUrl(returls);
        return dto;
    }
}

