/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.cache;

import cn.com.duiba.goods.center.biz.entity.AppItemEntity;
import cn.com.duiba.goods.center.biz.entity.ItemEntity;
import cn.com.duiba.goods.center.biz.service.item.AppItemService;
import cn.com.duiba.goods.center.biz.service.item.ItemService;
import cn.com.duiba.wolf.cache.AdvancedCacheClient;
import com.alibaba.ttl.threadpool.TtlExecutors;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class EventHomeCache
implements InitializingBean {
    private static Logger log = LoggerFactory.getLogger(EventHomeCache.class);
    @Resource(name="stringRedisTemplate03")
    private AdvancedCacheClient advancedCacheClient;
    @Resource(name="stringRedisTemplate03")
    private StringRedisTemplate stringRedisTemplate03;
    @Autowired
    private AppItemService appItemService;
    @Autowired
    private ItemService itemService;
    private static final List<Long> noRefreshList = Arrays.asList(191L);
    private static volatile Set<Long> enableAppIds = new HashSet<Long>();
    private static volatile Set<Long> appIdsSet = Collections.synchronizedSet(new HashSet());
    private static volatile Set<Long> itemIdsSet = Collections.synchronizedSet(new HashSet());
    private static volatile Set<Long> appItemIdsSet = Collections.synchronizedSet(new HashSet());
    private static volatile Set<Long> itemRemainingSet = Collections.synchronizedSet(new HashSet());
    private static volatile Set<Long> appItemRemainingSet = Collections.synchronizedSet(new HashSet());
    private static volatile Set<String> APPITEM_CACHE = Collections.synchronizedSet(new HashSet());
    static AtomicBoolean init = new AtomicBoolean();

    public void clearAppItemCache(String key) {
        APPITEM_CACHE.add(key);
    }

    public void invalidApp(Long appId) {
        appIdsSet.add(appId);
    }

    public void invalidItem(Long itemId) {
        itemIdsSet.add(itemId);
    }

    public void invalidItemRemaining(Long itemId) {
        itemRemainingSet.add(itemId);
    }

    public void invalidAppItem(Long appItemId) {
        appItemIdsSet.add(appItemId);
    }

    public void invalidAppItemRemaining(Long appItemId) {
        appItemRemainingSet.add(appItemId);
    }

    public void invalidAppItem(List<Long> appItemIds) {
        appItemIdsSet.addAll(appItemIds);
    }

    public void invalidRelationActivity(Long relationId, Integer type) {
        List<Long> appIds = this.appItemService.findAppIdsByInActivityId(relationId, type);
        if (appIds != null && !appIds.isEmpty()) {
            appIdsSet.addAll(appIds);
        }
    }

    public void invalidRelationActivity(Long relationId) {
        List<Long> appIds = this.appItemService.findAppIdsByActivityId(relationId);
        if (appIds != null && !appIds.isEmpty()) {
            appIdsSet.addAll(appIds);
        }
    }

    public void updateAppTimestamp(Long appId) {
        try {
            String cacheKey = "item.MS_HOME_ITEM_-" + appId;
            this.advancedCacheClient.set(cacheKey, (Object)System.currentTimeMillis(), 1, TimeUnit.HOURS);
        }
        catch (Exception e) {
            log.error("invalidAppHomeItemKeyCache error:", (Throwable)e);
        }
    }

    public Long getAppTimestamp(Long appId) {
        String cacheKey = "item.MS_HOME_ITEM_-" + appId;
        return (Long)this.advancedCacheClient.get(cacheKey);
    }

    private void init() {
        if (init.compareAndSet(false, init.get())) {
            ScheduledExecutorService es = TtlExecutors.getTtlScheduledExecutorService((ScheduledExecutorService)Executors.newScheduledThreadPool(3));
            es.scheduleWithFixedDelay(new Runnable(){

                private void process() {
                    Set appIds = (Set)EventHomeCache.this.advancedCacheClient.get("developer.center.enable.appIds");
                    if (appIds != null && !appIds.isEmpty()) {
                        enableAppIds.addAll(appIds);
                    }
                }

                @Override
                public void run() {
                    try {
                        this.process();
                    }
                    catch (Exception e) {
                        log.error("schedule run error", (Throwable)e);
                    }
                }
            }, 0L, 1L, TimeUnit.MINUTES);
            es.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    if (!APPITEM_CACHE.isEmpty()) {
                        Set temp = APPITEM_CACHE;
                        APPITEM_CACHE = Collections.synchronizedSet(new HashSet());
                        log.warn("clear appItemCache size:" + temp.size());
                        EventHomeCache.this.stringRedisTemplate03.delete((Collection)temp);
                    }
                }
            }, 1000L, 200L, TimeUnit.MILLISECONDS);
            es.scheduleWithFixedDelay(new Runnable(){

                private void process() {
                    Set tempItemIds = itemIdsSet;
                    Set tempAppItemIds = appItemIdsSet;
                    Set tempAppIds = appIdsSet;
                    Set tempItemRemaining = itemRemainingSet;
                    Set tempAppItemRemaining = appItemRemainingSet;
                    itemIdsSet = Collections.synchronizedSet(new HashSet());
                    appItemIdsSet = Collections.synchronizedSet(new HashSet());
                    appIdsSet = Collections.synchronizedSet(new HashSet());
                    itemRemainingSet = Collections.synchronizedSet(new HashSet());
                    appItemRemainingSet = Collections.synchronizedSet(new HashSet());
                    if (!tempAppItemRemaining.isEmpty()) {
                        List<AppItemEntity> ais = EventHomeCache.this.appItemService.findByIds(new ArrayList<Long>(tempAppItemRemaining));
                        for (AppItemEntity ai : ais) {
                            if (ai.getRemaining() == null || ai.getRemaining() > 0) continue;
                            tempAppIds.add(ai.getAppId());
                        }
                    }
                    if (!tempItemRemaining.isEmpty()) {
                        List<ItemEntity> items = EventHomeCache.this.itemService.findByIds(new ArrayList<Long>(tempItemRemaining));
                        for (ItemEntity item : items) {
                            if (item.getRemaining() == null || item.getRemaining() > 0) continue;
                            tempItemIds.add(item.getId());
                        }
                    }
                    if (!tempItemIds.isEmpty()) {
                        tempItemIds.removeAll(noRefreshList);
                        if (!tempItemIds.isEmpty()) {
                            List<Long> itemAppIds = EventHomeCache.this.appItemService.findAppIdByItemIds(new ArrayList<Long>(tempItemIds));
                            tempAppIds.addAll(itemAppIds);
                        }
                    }
                    if (!tempAppItemIds.isEmpty()) {
                        List<Long> appItemAppIds = EventHomeCache.this.appItemService.findAppIdsByIds(new ArrayList<Long>(tempAppItemIds));
                        tempAppIds.addAll(appItemAppIds);
                    }
                    int temp = 0;
                    for (Long appId : tempAppIds) {
                        if (!enableAppIds.contains(appId)) continue;
                        EventHomeCache.this.updateAppTimestamp(appId);
                        ++temp;
                    }
                    EventHomeCache.this.warnLog(temp, tempItemIds, tempAppItemIds);
                }

                @Override
                public void run() {
                    try {
                        this.process();
                    }
                    catch (Exception e) {
                        log.error("schedule run error", (Throwable)e);
                    }
                }
            }, 1000L, 200L, TimeUnit.MILLISECONDS);
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.init();
    }

    private void warnLog(int appNum, Set<Long> item, Set<Long> appItem) {
        if (appNum > 100) {
            StringBuffer itemIds = new StringBuffer("[");
            for (Long id : item) {
                itemIds.append(id).append(",");
            }
            itemIds.append("]");
            StringBuffer appItemIds = new StringBuffer("[");
            for (Long id : appItem) {
                appItemIds.append(id).append(",");
            }
            appItemIds.append("]");
            log.warn("refresh homeCache warn : app=" + appNum + " itemIds=" + itemIds.toString() + " appItemIds=" + appItemIds.toString());
        }
    }
}

