/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.dao.item.impl;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.AppItemDto;
import cn.com.duiba.goods.center.biz.dao.BaseCreditsDao;
import cn.com.duiba.goods.center.biz.dao.item.AppItemDao;
import cn.com.duiba.goods.center.biz.entity.AppItemEntity;
import cn.com.duiba.goods.center.common.ErrorCode;
import cn.com.duiba.goods.center.common.RuntimeGoodsException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;

@Repository(value="appItemDao")
public class AppItemDaoImpl
extends BaseCreditsDao
implements AppItemDao {
    private String appIdKey = "appId";
    private String statusKey = "status";

    @Override
    public AppItemEntity find(Long id) {
        HashMap<String, Long> queryMap = new HashMap<String, Long>();
        queryMap.put("id", id);
        return (AppItemEntity)this.getSqlSession().selectOne(this.getStamentNameSpace("find"), queryMap);
    }

    @Override
    public List<AppItemEntity> findByIds(List<Long> ids) {
        HashMap<String, List<Long>> queryMap = new HashMap<String, List<Long>>();
        queryMap.put("ids", ids);
        return this.getSqlSession().selectList(this.getStamentNameSpace("findByIds"), queryMap);
    }

    @Override
    public void insert(AppItemEntity appItemEntity) {
        this.getSqlSession().insert(this.getStamentNameSpace("insert"), (Object)appItemEntity);
    }

    @Override
    public Integer update(AppItemEntity appItemEntity) {
        return this.getSqlSession().update(this.getStamentNameSpace("update"), (Object)appItemEntity);
    }

    @Override
    public Integer delete(Long appId, Long id) {
        HashMap<String, Long> queryMap = new HashMap<String, Long>();
        queryMap.put(this.appIdKey, appId);
        queryMap.put("id", id);
        return this.getSqlSession().update(this.getStamentNameSpace("delete"), queryMap);
    }

    @Override
    public Integer deleteByIds(Long appId, List<Long> ids) {
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put(this.appIdKey, appId);
        queryMap.put("ids", ids);
        return this.getSqlSession().update(this.getStamentNameSpace("deleteByIds"), queryMap);
    }

    @Override
    public Integer updateStatus(Long appId, Long id, String status) {
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put(this.appIdKey, appId);
        queryMap.put("id", id);
        queryMap.put(this.statusKey, status);
        return this.getSqlSession().update(this.getStamentNameSpace("updateStatus"), queryMap);
    }

    @Override
    public Integer updateStatusByIds(Long appId, List<Long> ids, String status) {
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put(this.appIdKey, appId);
        queryMap.put("ids", ids);
        queryMap.put(this.statusKey, status);
        return this.getSqlSession().update(this.getStamentNameSpace("updateStatusByIds"), queryMap);
    }

    @Override
    public Integer decrStock(Long id) {
        HashMap<String, Long> queryMap = new HashMap<String, Long>();
        queryMap.put("id", id);
        return this.getSqlSession().update(this.getStamentNameSpace("decrStock"), queryMap);
    }

    @Override
    public Integer incrStock(Long id) {
        HashMap<String, Long> queryMap = new HashMap<String, Long>();
        queryMap.put("id", id);
        return this.getSqlSession().update(this.getStamentNameSpace("incrStock"), queryMap);
    }

    @Override
    public Integer appendStock(Long id, Long number) {
        HashMap<String, Long> queryMap = new HashMap<String, Long>();
        queryMap.put("id", id);
        queryMap.put("number", number);
        return this.getSqlSession().update(this.getStamentNameSpace("appendStock"), queryMap);
    }

    @Override
    public Integer deductStock(Long id, Long number) {
        HashMap<String, Long> queryMap = new HashMap<String, Long>();
        queryMap.put("id", id);
        queryMap.put("number", number);
        return this.getSqlSession().update(this.getStamentNameSpace("deductStock"), queryMap);
    }

    @Override
    public AppItemEntity findByAppIdAndItemId(Long appId, Long itemId) {
        HashMap<String, Long> queryMap = new HashMap<String, Long>();
        queryMap.put(this.appIdKey, appId);
        queryMap.put("itemId", itemId);
        return (AppItemEntity)this.getSqlSession().selectOne(this.getStamentNameSpace("findByAppIdAndItemId"), queryMap);
    }

    @Override
    public Integer updateRemainingAndvalidEndDate(Long appItemId, Long totalStock, Date validEndDate) {
        HashMap<String, Comparable<Long>> queryMap = new HashMap<String, Comparable<Long>>();
        queryMap.put("id", appItemId);
        queryMap.put("totalStock", totalStock);
        queryMap.put("validEndDate", validEndDate);
        return this.getSqlSession().update(this.getStamentNameSpace("updateRemainingAndvalidEndDate"), queryMap);
    }

    @Override
    public Integer updateExpiedAppItem(Long itemId) {
        HashMap<String, Long> queryMap = new HashMap<String, Long>();
        queryMap.put("itemId", itemId);
        return this.getSqlSession().update(this.getStamentNameSpace("updateExpiedAppItem"), queryMap);
    }

    @Override
    public Integer updateExpiedAppItemById(Long appItemId) {
        HashMap<String, Long> queryMap = new HashMap<String, Long>();
        queryMap.put("appItemId", appItemId);
        return this.getSqlSession().update(this.getStamentNameSpace("updateExpiedAppItemById"), queryMap);
    }

    @Override
    public List<AppItemDto> findhomeAppItemNeed(Long appId) {
        return this.getSqlSession().selectList(this.getStamentNameSpace("findhomeAppItemNeed"), (Object)appId);
    }

    @Override
    public List<Long> findAppIdsByInActivityId(Long activityId, Integer type) {
        HashMap<String, Number> paramMap = new HashMap<String, Number>();
        paramMap.put("activityId", activityId);
        paramMap.put("type", type);
        return this.getSqlSession().selectList(this.getStamentNameSpace("findAppIdsByInActivityId"), paramMap);
    }

    @Override
    public List<Long> findAppIdsByActivityId(Long relationId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("relationId", relationId);
        return this.getSqlSession().selectList(this.getStamentNameSpace("findAppIdsByActivityId"), paramMap);
    }

    @Override
    public List<Long> findIdsByActivityIds(List<Long> relationIds) {
        HashMap<String, List<Long>> paramMap = new HashMap<String, List<Long>>();
        paramMap.put("relationIds", relationIds);
        return this.getSqlSession().selectList(this.getStamentNameSpace("findIdsByActivityIds"), paramMap);
    }

    @Override
    public List<Long> findAppIdByItemIds(List<Long> itemIds) {
        HashMap<String, List<Long>> paramMap = new HashMap<String, List<Long>>();
        paramMap.put("itemIds", itemIds);
        return this.getSqlSession().selectList(this.getStamentNameSpace("findAppIdByItemIds"), paramMap);
    }

    @Override
    public List<AppItemDto> findAppItemsByAppIdAndIds(Long appId, String status, List<Long> ids) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("appId", appId);
        paramMap.put(this.statusKey, status);
        paramMap.put("ids", ids);
        return this.getSqlSession().selectList(this.getStamentNameSpace("findAppItemsByAppIdAndIds"), paramMap);
    }

    @Override
    public List<Long> findAppIdsByIds(List<Long> ids) {
        HashMap<String, List<Long>> paramMap = new HashMap<String, List<Long>>();
        paramMap.put("ids", ids);
        return this.getSqlSession().selectList(this.getStamentNameSpace("findAppIdsByIds"), paramMap);
    }

    @Override
    public List<Long> findIdByItemId(Long itemId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("itemId", itemId);
        return this.getSqlSession().selectList(this.getStamentNameSpace("findIdByItemId"), paramMap);
    }

    @Override
    public List<Long> findIDBySourceIdsAndSourceTypes(List<Long> sourceIds, List<Integer> sourceTypes) {
        if (sourceIds.isEmpty() || sourceTypes.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<String, List<Number>> paramMap = new HashMap<String, List<Number>>();
        paramMap.put("sourceIds", sourceIds);
        paramMap.put("sourceTypes", sourceTypes);
        return this.getSqlSession().selectList(this.getStamentNameSpace("findIDBySourceIdsAndSourceTypes"), paramMap);
    }

    @Override
    public int updateStatusByActivityIds(String status, Boolean delete, List<Long> oids) {
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("status", status);
        queryMap.put("delete", delete);
        queryMap.put("oids", oids);
        return this.getSqlSession().update(this.getStamentNameSpace("updateStatusByActivityIds"), queryMap);
    }

    @Override
    public List<AppItemDto> findByLimit(Map<String, Object> params) {
        return this.getSqlSession().selectList(this.getStamentNameSpace("findByLimit"), params);
    }

    @Override
    public int findAppMaxPayload(Long appId) {
        Map<String, Object> param = this.getBlankParams();
        param.put("appId", appId);
        param.put("topStart", 1000000);
        int payload = (Integer)this.getSqlSession().selectOne(this.getStamentNameSpace("findAppMaxPayload"), param);
        if (payload > 1000000) {
            throw new RuntimeGoodsException(ErrorCode.E9999999);
        }
        return payload;
    }
}

