/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.dao.item.impl;

import cn.com.duiba.goods.center.biz.dao.BaseCreditsDao;
import cn.com.duiba.goods.center.biz.dao.item.CouponBatchDao;
import cn.com.duiba.goods.center.biz.entity.CouponBatchEntity;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository
public class CouponBatchDaoImpl
extends BaseCreditsDao
implements CouponBatchDao {
    private String itemIdKey = "itemId";
    private String appItemIdKey = "appItemId";
    private String batchIdKey = "batchId";
    private String validStartDateKey = "validStartDate";
    private String validEndDateKey = "validEndDate";

    @Override
    public void insert(CouponBatchEntity couponBatchEntity) {
        this.getSqlSession().insert(this.getStamentNameSpace("insert"), (Object)couponBatchEntity);
    }

    @Override
    public int update(CouponBatchEntity couponBatchEntity) {
        return this.getSqlSession().update(this.getStamentNameSpace("update"), (Object)couponBatchEntity);
    }

    @Override
    public CouponBatchEntity findForUpdate(Long id) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("id", id);
        return (CouponBatchEntity)this.getSqlSession().selectOne(this.getStamentNameSpace("findForUpdate"), paramMap);
    }

    @Override
    public CouponBatchEntity find(Long id) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("id", id);
        return (CouponBatchEntity)this.getSqlSession().selectOne(this.getStamentNameSpace("find"), paramMap);
    }

    @Override
    public CouponBatchEntity findLastBatchByItemId(Long itemId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put(this.itemIdKey, itemId);
        return (CouponBatchEntity)this.getSqlSession().selectOne(this.getStamentNameSpace("findLastBatchByItemId"), paramMap);
    }

    @Override
    public List<CouponBatchEntity> findAllBatch(Long appItemId, Long itemId, String valid) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put(this.appItemIdKey, appItemId);
        paramMap.put(this.itemIdKey, itemId);
        paramMap.put("valid", valid);
        return this.getSqlSession().selectList(this.getStamentNameSpace("findAllBatch"), paramMap);
    }

    @Override
    public void updateAllNewOverDueBatch() {
        this.getSqlSession().update(this.getStamentNameSpace("updateAllNewOverDueBatch"));
    }

    @Override
    public List<Long> selectIdsOfNewOverDueBatch() {
        return this.getSqlSession().selectList(this.getStamentNameSpace("selectIdsOfNewOverDueBatch"));
    }

    @Override
    public void setItemBatchEmpty(Long itemId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put(this.itemIdKey, itemId);
        this.getSqlSession().update(this.getStamentNameSpace("setItemBatchEmpty"), paramMap);
    }

    @Override
    public void setAppItemBatchEmpty(Long appItemId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put(this.appItemIdKey, appItemId);
        this.getSqlSession().update(this.getStamentNameSpace("setAppItemBatchEmpty"), paramMap);
    }

    @Override
    public CouponBatchEntity findBatchByValidEndDate(Long appItemId, Long itemId, Date validEndDate) {
        HashMap<String, Comparable<Long>> paramMap = new HashMap<String, Comparable<Long>>();
        paramMap.put(this.appItemIdKey, appItemId);
        paramMap.put(this.itemIdKey, itemId);
        paramMap.put(this.validEndDateKey, validEndDate);
        return (CouponBatchEntity)this.getSqlSession().selectOne(this.getStamentNameSpace("findBatchByValidEndDate"), paramMap);
    }

    @Override
    public CouponBatchEntity findBatchByValidStartDateAndValidEndDate(Long appItemId, Long itemId, Date validStartDate, Date validEndDate) {
        HashMap<String, Comparable<Long>> paramMap = new HashMap<String, Comparable<Long>>();
        paramMap.put(this.appItemIdKey, appItemId);
        paramMap.put(this.itemIdKey, itemId);
        paramMap.put(this.validStartDateKey, validStartDate);
        paramMap.put(this.validEndDateKey, validEndDate);
        return (CouponBatchEntity)this.getSqlSession().selectOne(this.getStamentNameSpace("findBatchByValidStartDateAndValidEndDate"), paramMap);
    }

    @Override
    public Date getMaxValidEndDate(Long appItemId, Long itemId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put(this.appItemIdKey, appItemId);
        paramMap.put(this.itemIdKey, itemId);
        return (Date)this.getSqlSession().selectOne(this.getStamentNameSpace("getMaxValidEndDate"), paramMap);
    }

    @Override
    public Date getMinValidEndDate(Long appItemId, Long itemId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put(this.appItemIdKey, appItemId);
        paramMap.put(this.itemIdKey, itemId);
        return (Date)this.getSqlSession().selectOne(this.getStamentNameSpace("getMinValidEndDate"), paramMap);
    }

    @Override
    public Integer countAllRemaining(Long appItemId, Long itemId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put(this.appItemIdKey, appItemId);
        paramMap.put(this.itemIdKey, itemId);
        return (Integer)this.getSqlSession().selectOne(this.getStamentNameSpace("countAllRemaining"), paramMap);
    }

    @Override
    public Integer deleteBatchRecord(Long batchId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put(this.batchIdKey, batchId);
        return this.getSqlSession().delete(this.getStamentNameSpace("deleteBatchRecord"), paramMap);
    }

    @Override
    public Integer turnbackCouponBatchRemaining(Long batchId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put(this.batchIdKey, batchId);
        return this.getSqlSession().update(this.getStamentNameSpace("turnbackCouponBatchRemaining"), paramMap);
    }

    @Override
    public Integer reduceCouponBatchRemaining(Long batchId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put(this.batchIdKey, batchId);
        return this.getSqlSession().update(this.getStamentNameSpace("reduceCouponBatchRemaining"), paramMap);
    }

    @Override
    public Integer countBatchRemaining(Long batchId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put(this.batchIdKey, batchId);
        return (Integer)this.getSqlSession().selectOne(this.getStamentNameSpace("countBatchRemaining"), paramMap);
    }

    @Override
    public List<CouponBatchEntity> findBatchInIds(List<Long> ids) {
        HashMap<String, List<Long>> paramMap = new HashMap<String, List<Long>>();
        paramMap.put("ids", ids);
        return this.getSqlSession().selectList(this.getStamentNameSpace("findBatchInIds"), paramMap);
    }

    @Override
    public CouponBatchEntity findItemNextBatch(Long itemId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put(this.itemIdKey, itemId);
        return (CouponBatchEntity)this.getSqlSession().selectOne(this.getStamentNameSpace("findItemNextBatch"), paramMap);
    }

    @Override
    public CouponBatchEntity findAppItemNextBatch(Long appItemId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put(this.appItemIdKey, appItemId);
        return (CouponBatchEntity)this.getSqlSession().selectOne(this.getStamentNameSpace("findAppItemNextBatch"), paramMap);
    }

    @Override
    public CouponBatchEntity findItemMaxValidEndDateBatch(Long itemId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put(this.itemIdKey, itemId);
        return (CouponBatchEntity)this.getSqlSession().selectOne(this.getStamentNameSpace("findItemMaxValidEndDateBatch"), paramMap);
    }

    @Override
    public CouponBatchEntity findAppItemMaxValidEndDateBatch(Long appItemId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put(this.appItemIdKey, appItemId);
        return (CouponBatchEntity)this.getSqlSession().selectOne(this.getStamentNameSpace("findAppItemMaxValidEndDateBatch"), paramMap);
    }

    @Override
    public int updateActiveAndRemaining(Long id, Integer active, Integer remaining) {
        HashMap<String, Number> paramMap = new HashMap<String, Number>();
        paramMap.put("id", id);
        paramMap.put("active", active);
        paramMap.put("remaining", remaining);
        return this.getSqlSession().update(this.getStamentNameSpace("updateActiveAndRemaining"), paramMap);
    }

    @Override
    public int updateActive(Long id, Integer active) {
        HashMap<String, Number> paramMap = new HashMap<String, Number>();
        paramMap.put("id", id);
        paramMap.put("active", active);
        return this.getSqlSession().update(this.getStamentNameSpace("updateActive"), paramMap);
    }

    @Override
    public CouponBatchEntity findItemBatchByValidStartDateAndValidEndDate(Long itemId, Date validStartDate, Date validEndDate) {
        HashMap<String, Comparable<Long>> paramMap = new HashMap<String, Comparable<Long>>();
        paramMap.put(this.itemIdKey, itemId);
        paramMap.put(this.validStartDateKey, validStartDate);
        paramMap.put(this.validEndDateKey, validEndDate);
        return (CouponBatchEntity)this.getSqlSession().selectOne(this.getStamentNameSpace("findItemBatchByValidStartDateAndValidEndDate"), paramMap);
    }

    @Override
    public CouponBatchEntity findAppItemBatchByValidStartDateAndValidEndDate(Long appItemId, Date validStartDate, Date validEndDate) {
        HashMap<String, Comparable<Long>> paramMap = new HashMap<String, Comparable<Long>>();
        paramMap.put(this.appItemIdKey, appItemId);
        paramMap.put(this.validStartDateKey, validStartDate);
        paramMap.put(this.validEndDateKey, validEndDate);
        return (CouponBatchEntity)this.getSqlSession().selectOne(this.getStamentNameSpace("findAppItemBatchByValidStartDateAndValidEndDate"), paramMap);
    }

    @Override
    public List<CouponBatchEntity> findAllBatchSimple(Long appItemId) {
        return this.getSqlSession().selectList(this.getStamentNameSpace("findAllBatchSimple"), (Object)appItemId);
    }

    @Override
    public Long findBatchNum(Long appItemId) {
        return (Long)this.getSqlSession().selectOne(this.getStamentNameSpace("findBatchNum"), (Object)appItemId);
    }

    @Override
    public Integer asyncUpdateBatchStock(Long batchId, int decrease) {
        HashMap<String, Number> paramMap = new HashMap<String, Number>();
        paramMap.put(this.batchIdKey, batchId);
        paramMap.put("decrease", decrease);
        return this.getSqlSession().update(this.getStamentNameSpace("asyncUpdateBatchStock"), paramMap);
    }

    @Override
    public int setItemBatchId(Long itemId, Long batchId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put(this.batchIdKey, batchId);
        paramMap.put(this.itemIdKey, itemId);
        return this.getSqlSession().update(this.getStamentNameSpace("setItemBatchId"), paramMap);
    }

    @Override
    public int setAppItemBatchId(Long appItemId, Long batchId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put(this.batchIdKey, batchId);
        paramMap.put(this.appItemIdKey, appItemId);
        return this.getSqlSession().update(this.getStamentNameSpace("setAppItemBatchId"), paramMap);
    }
}

