/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.dao.item.impl;

import cn.com.duiba.goods.center.biz.dao.BaseCreditsDao;
import cn.com.duiba.goods.center.biz.dao.item.CouponDao;
import cn.com.duiba.goods.center.biz.entity.CouponEntity;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;

@Repository
public class CouponDaoImpl
extends BaseCreditsDao
implements CouponDao {
    private String itemIdKey = "itemId";
    private String appItemIdKey = "appItemId";
    private String batchIdKey = "batchId";

    @Override
    public CouponEntity find(Long id) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("id", id);
        return (CouponEntity)this.getSqlSession().selectOne(this.getStamentNameSpace("find"), paramMap);
    }

    @Override
    public void releaseCouponById(Long couponId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("couponId", couponId);
        this.getSqlSession().update(this.getStamentNameSpace("releaseCouponById"), paramMap);
    }

    @Override
    public int batchInsertCoupon(List<CouponEntity> ls) {
        HashMap<String, List<CouponEntity>> paramMap = new HashMap<String, List<CouponEntity>>();
        paramMap.put("list", ls);
        return this.getSqlSession().insert(this.getStamentNameSpace("batchInsertCoupon"), paramMap);
    }

    @Override
    public Integer batchDeleteCoupon(List<Long> ls) {
        HashMap<String, List<Long>> paramMap = new HashMap<String, List<Long>>();
        paramMap.put("list", ls);
        return this.getSqlSession().delete(this.getStamentNameSpace("batchDeleteCoupon"), paramMap);
    }

    @Override
    public Integer deleteOneCoupon(Long id) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("id", id);
        return this.getSqlSession().delete(this.getStamentNameSpace("deleteOneCoupon"), paramMap);
    }

    @Override
    public Integer deleteCouponByBatch(Long batchId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put(this.batchIdKey, batchId);
        return this.getSqlSession().delete(this.getStamentNameSpace("deleteCouponByBatch"), paramMap);
    }

    @Override
    public Integer ishavingCoupon(Long batchId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put(this.batchIdKey, batchId);
        return (Integer)this.getSqlSession().selectOne(this.getStamentNameSpace("ishavingCoupon"), paramMap);
    }

    @Override
    public CouponEntity getOneCouponByBatchForUpdate(Long batchId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put(this.batchIdKey, batchId);
        return (CouponEntity)this.getSqlSession().selectOne(this.getStamentNameSpace("getOneCouponByBatchForUpdate"), paramMap);
    }

    @Override
    public CouponEntity findOneByBatch(Long batchId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put(this.batchIdKey, batchId);
        return (CouponEntity)this.getSqlSession().selectOne(this.getStamentNameSpace("findOneByBatch"), paramMap);
    }

    @Override
    public CouponEntity findByBatchAndCode(Long batchId, String code) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put(this.batchIdKey, batchId);
        paramMap.put("code", code);
        return (CouponEntity)this.getSqlSession().selectOne(this.getStamentNameSpace("findByBatchAndCode"), paramMap);
    }

    @Override
    public List<CouponEntity> findNoUsedByBatch(Long batchId, Integer max) {
        HashMap<String, Number> paramMap = new HashMap<String, Number>();
        paramMap.put(this.batchIdKey, batchId);
        paramMap.put("max", max);
        return this.getSqlSession().selectList(this.getStamentNameSpace("findNoUsedByBatch"), paramMap);
    }

    @Override
    public List<CouponEntity> searchCoupon(Long appItemId, Long itemId, String code, Long batchId, String used, Integer start, Integer pageSize) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put(this.appItemIdKey, appItemId);
        paramMap.put(this.itemIdKey, itemId);
        paramMap.put("code", code);
        paramMap.put(this.batchIdKey, batchId);
        paramMap.put("used", used);
        paramMap.put("start", start);
        paramMap.put("pageSize", pageSize);
        return this.getSqlSession().selectList(this.getStamentNameSpace("searchCoupon"), paramMap);
    }

    @Override
    public Integer countCoupon(Long appItemId, Long itemId, Long batchId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put(this.appItemIdKey, appItemId);
        paramMap.put(this.itemIdKey, itemId);
        paramMap.put(this.batchIdKey, batchId);
        return (Integer)this.getSqlSession().selectOne(this.getStamentNameSpace("countCoupon"), paramMap);
    }

    @Override
    public Integer countUsedCoupon(Long appItemId, Long itemId, Long batchId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put(this.appItemIdKey, appItemId);
        paramMap.put(this.itemIdKey, itemId);
        paramMap.put(this.batchIdKey, batchId);
        return (Integer)this.getSqlSession().selectOne(this.getStamentNameSpace("countUsedCoupon"), paramMap);
    }

    @Override
    public Integer countByItemId(Long itemId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put(this.itemIdKey, itemId);
        return (Integer)this.getSqlSession().selectOne(this.getStamentNameSpace("countByItemId"), paramMap);
    }

    @Override
    public List<CouponEntity> findCouponList(List<Long> list) {
        HashMap<String, List<Long>> paramMap = new HashMap<String, List<Long>>();
        paramMap.put("list", list);
        return this.getSqlSession().selectList(this.getStamentNameSpace("findCouponList"), paramMap);
    }

    @Override
    public Integer countByCouponBatch(Long batchId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put(this.batchIdKey, batchId);
        return (Integer)this.getSqlSession().selectOne(this.getStamentNameSpace("countByCouponBatch"), paramMap);
    }

    @Override
    public List<CouponEntity> findCouponByLimit(Map<String, Object> params) {
        return this.getSqlSession().selectList(this.getStamentNameSpace("findCouponByLimit"), params);
    }

    @Override
    public Long findCouponByCount(Map<String, Object> params) {
        return (Long)this.getSqlSession().selectOne(this.getStamentNameSpace("findCouponByCount"), params);
    }

    @Override
    public List<CouponEntity> findCouponByBatchAndTotal(Map<String, Object> map) {
        return this.getSqlSession().selectList(this.getStamentNameSpace("findCouponByBatchAndTotal"), map);
    }

    @Override
    public int lockCoupon(long id) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("id", id);
        return this.getSqlSession().update(this.getStamentNameSpace("lockCoupon"), paramMap);
    }

    @Override
    public int unlockCoupon(long id) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("id", id);
        return this.getSqlSession().update(this.getStamentNameSpace("unlockCoupon"), paramMap);
    }

    @Override
    public int deleteByBatchId(long batchId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put(this.batchIdKey, batchId);
        return this.getSqlSession().delete(this.getStamentNameSpace("deleteByBatchId"), paramMap);
    }

    @Override
    public List<String> findAllCodeByBatchId(long batchId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put(this.batchIdKey, batchId);
        return this.getSqlSession().selectList(this.getStamentNameSpace("findAllCodeByBatchId"), paramMap);
    }

    @Override
    public Integer noLockCountByBatchId(Long batchId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put(this.batchIdKey, batchId);
        return (Integer)this.getSqlSession().selectOne(this.getStamentNameSpace("noLockCountByBatchId"), paramMap);
    }

    @Override
    public CouponEntity findOneCouponByBatchId(Long batchId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put(this.batchIdKey, batchId);
        return (CouponEntity)this.getSqlSession().selectOne(this.getStamentNameSpace("findOneCouponByBatchId"), paramMap);
    }

    @Override
    public List<CouponEntity> findCouponsForUpdate(long batchId, int limit) {
        HashMap<String, Number> paramMap = new HashMap<String, Number>();
        paramMap.put("limit", limit);
        paramMap.put(this.batchIdKey, batchId);
        return this.getSqlSession().selectList(this.getStamentNameSpace("findCouponsForUpdate"), paramMap);
    }

    @Override
    public Integer asyncLockedCoupon(List<Long> ids) {
        HashMap<String, List<Long>> paramMap = new HashMap<String, List<Long>>();
        paramMap.put("ids", ids);
        return (Integer)this.getSqlSession().selectOne(this.getStamentNameSpace("asyncLockedCoupon"), paramMap);
    }

    @Override
    public int useCoupon(Long couponId, Long orderId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("couponId", couponId);
        paramMap.put("orderId", orderId);
        return this.getSqlSession().update(this.getStamentNameSpace("useCoupon"), paramMap);
    }

    @Override
    public void insert(CouponEntity couponEntity) {
        this.getSqlSession().insert(this.getStamentNameSpace("insert"), (Object)couponEntity);
    }
}

