/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.remoteservice.impl;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsBatchDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsCouponDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsStockDto;
import cn.com.duiba.goods.center.api.remoteservice.front.RemoteGoodsCouponService;
import cn.com.duiba.goods.center.biz.bo.GoodsCouponBO;
import cn.com.duiba.goods.center.biz.entity.GoodsBatchEntity;
import cn.com.duiba.goods.center.biz.entity.GoodsCouponEntity;
import cn.com.duiba.goods.center.biz.service.GoodsBatchService;
import cn.com.duiba.goods.center.biz.service.GoodsCouponService;
import cn.com.duiba.goods.center.biz.util.PCGConvertUtil;
import cn.com.duiba.wolf.dubbo.DubboResult;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="remoteGoodsCouponService")
public class RemoteGoodsCouponServiceImpl
implements RemoteGoodsCouponService {
    private static Logger log = LoggerFactory.getLogger(RemoteGoodsCouponServiceImpl.class);
    @Autowired
    private GoodsCouponBO goodsCouponBO;
    @Autowired
    private GoodsCouponService goodsCouponService;
    @Autowired
    private GoodsBatchService goodsBatchService;

    public DubboResult<Boolean> completeCoupon(Long couponId, long orderId) {
        try {
            this.goodsCouponBO.completeCoupon(couponId, orderId);
            return DubboResult.successResult((Object)true);
        }
        catch (Exception e) {
            log.error("takeCoupon couponId=" + couponId + ",orderId=" + orderId, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> rollbackCoupon(Long couponId, String bizNum) {
        try {
            Boolean ret = this.goodsCouponBO.rollbackCoupon(couponId, bizNum);
            return DubboResult.successResult((Object)ret);
        }
        catch (Exception e) {
            log.error("rollbackCoupon couponId=" + couponId, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<GoodsCouponDto> findCoupon(GoodsTypeEnum gtype, long gid, Long couponId) {
        try {
            if (couponId == null || couponId < 1L || String.valueOf(couponId).length() < 4) {
                log.warn("findCoupon\uff1a parameter error: gtype=" + gtype.getGtype() + " ,gid=" + gid + ",couponId=" + couponId);
                return null;
            }
            GoodsCouponEntity coupon = this.goodsCouponBO.findCoupon(couponId);
            GoodsBatchEntity batch = this.goodsCouponBO.findBatch(coupon.getGoodsBatchId());
            GoodsCouponDto dto = PCGConvertUtil.convert(coupon);
            dto.setStartDay(batch.getStartDay());
            dto.setOverDue(batch.getEndDay());
            return DubboResult.successResult((Object)dto);
        }
        catch (Exception e) {
            log.error("findCoupon gtype=" + gtype.getGtype() + ",gid= " + gid + ",couponId=" + couponId, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Long> findGoodsStock(GoodsTypeEnum gtype, long gid) {
        try {
            long stock = this.goodsCouponBO.findGoodsStock(gtype, gid);
            return DubboResult.successResult((Object)stock);
        }
        catch (Exception e) {
            log.error("findCurrentBacthStock gtype=" + gtype.getGtype() + ",gid=" + gid, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<GoodsStockDto>> findGoodsStockByBatch(List<GoodsStockDto> goods) {
        try {
            List<GoodsStockDto> dtos = this.goodsCouponBO.findGoodsStockByBatch(goods);
            return DubboResult.successResult(dtos);
        }
        catch (Exception e) {
            log.error("findCurrentBatchStockByBatch", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<GoodsBatchDto> findUsingBatch(GoodsTypeEnum gtype, long gid) {
        try {
            GoodsBatchEntity batch = this.goodsCouponBO.findUsingBatch(gtype, gid);
            if (batch != null) {
                GoodsBatchDto dto = PCGConvertUtil.convert(batch);
                return DubboResult.successResult((Object)dto);
            }
            return DubboResult.failResult((String)"\u6ca1\u6709\u4f7f\u7528\u4e2d\u7684\u6279\u6b21");
        }
        catch (Exception e) {
            log.error("findUsingBatch gtype=" + gtype.getGtype() + ",gid=" + gid, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public GoodsCouponDto findCoupon(long couponId) {
        if (couponId < 1L || String.valueOf(couponId).length() < 4) {
            log.warn("findCoupon\uff1a parameter error: couponId=" + couponId);
            return null;
        }
        GoodsCouponEntity coupon = this.goodsCouponService.find(couponId);
        long batchId = coupon.getGoodsBatchId();
        GoodsBatchEntity batch = this.goodsBatchService.find(batchId);
        GoodsCouponDto dto = PCGConvertUtil.convert(coupon);
        dto.setOverDue(batch.getEndDay());
        return dto;
    }

    public DubboResult<GoodsCouponDto> takeCoupon(GoodsTypeEnum gtype, long gid, Long consumerId, Long appId, String bizNum) {
        try {
            GoodsCouponDto dto = this.goodsCouponBO.takeCoupon(gtype, gid, consumerId, appId, bizNum);
            if (dto == null) {
                return DubboResult.successResult(null);
            }
            return DubboResult.successResult((Object)dto);
        }
        catch (Exception e) {
            log.error("takeCoupon gtype=" + gtype.getGtype() + ", gid=" + gid + ",consumerId=" + consumerId + ",appId=" + appId + ",bizNum=" + bizNum, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<GoodsCouponDto> findCouponById(Long couponId) {
        try {
            if (couponId == null || couponId < 1L || String.valueOf(couponId).length() < 4) {
                log.warn("findCoupon\uff1a parameter error couponId=" + couponId);
                return DubboResult.failResult((String)"\u8bf7\u6c42\u53c2\u6570\u9519\u8bef");
            }
            GoodsCouponEntity coupon = this.goodsCouponService.find(couponId);
            if (coupon == null) {
                return DubboResult.successResult(null);
            }
            long batchId = coupon.getGoodsBatchId();
            GoodsBatchEntity batch = this.goodsBatchService.find(batchId);
            GoodsCouponDto dto = PCGConvertUtil.convert(coupon);
            dto.setOverDue(batch.getEndDay());
            return DubboResult.successResult((Object)dto);
        }
        catch (Exception e) {
            log.error("findCouponById\uff1a parameter error couponId=" + couponId, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }
}

