/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.remoteservice.impl;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.dto.ImmediatelyButtonDto;
import cn.com.duiba.goods.center.api.remoteservice.front.RemoteImmediatelyButtonService;
import cn.com.duiba.goods.center.biz.bo.ImmediatelyButtonBackendBo;
import cn.com.duiba.goods.center.common.ErrorCode;
import cn.com.duiba.goods.center.common.RuntimeGoodsException;
import cn.com.duiba.wolf.dubbo.DubboResult;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="remoteImmediatelyButtonService")
public class RemoteImmediatelyButtonServiceImpl
implements RemoteImmediatelyButtonService {
    private static final Logger log = LoggerFactory.getLogger(RemoteImmediatelyButtonServiceImpl.class);
    @Resource
    private ImmediatelyButtonBackendBo immediatelyButtonBackendBo;

    public DubboResult<String> selectImmediatelyButton(Long gid, GoodsTypeEnum gtype, Long orderId, String userAgent, String hdtoolFalg, String urlParameter, String embedClickurl) {
        try {
            if (gid == null || gtype == null || userAgent == null || hdtoolFalg == null) {
                throw new RuntimeGoodsException(ErrorCode.E0404004);
            }
            String ret = this.immediatelyButtonBackendBo.selectImmediatelyButtonFromItem(gid, gtype, orderId, userAgent, hdtoolFalg, urlParameter, embedClickurl);
            return DubboResult.successResult((Object)ret);
        }
        catch (RuntimeGoodsException e) {
            log.warn("selectImmediatelyButtonFromCoupon:gid=" + gid + ",gtype=" + gtype + ",orderId= " + orderId + ",userAgent:" + userAgent + ",hdtoolFalg= " + hdtoolFalg + ",urlParameter=" + urlParameter + ",embedClickurl=" + embedClickurl, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<String> selectImmediatelyButtonFromCoupon(Long couponId, Long itemId, Long orderId, String urlParameter, String embedClickurl, String hdtoolFalg) {
        try {
            if (itemId == null || orderId == null || couponId == null) {
                throw new RuntimeGoodsException(ErrorCode.E0404004);
            }
            String ret = this.immediatelyButtonBackendBo.selectImmediatelyButtonFromCoupon(couponId, itemId, orderId, urlParameter, embedClickurl);
            return DubboResult.successResult((Object)ret);
        }
        catch (RuntimeGoodsException e) {
            log.warn("selectImmediatelyButtonFromCoupon:couponId=" + couponId + ",itemId=" + itemId + ",orderId=" + orderId + ",urlParameter:" + urlParameter + ",embedClickurl=" + embedClickurl + ",hdtoolFalg=" + hdtoolFalg, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<ImmediatelyButtonDto> selectImmediatelyForPlatfrom(Long gid, GoodsTypeEnum gtype, Long orderId, String userAgent, String hdtoolFalg, String consunmerId) {
        try {
            if (gid == null || gtype == null || userAgent == null || hdtoolFalg == null) {
                throw new RuntimeGoodsException(ErrorCode.E0404004);
            }
            ImmediatelyButtonDto ret = this.immediatelyButtonBackendBo.selectImmediatelyForPlatfrom(gid, gtype, orderId, userAgent, hdtoolFalg, consunmerId);
            return DubboResult.successResult((Object)ret);
        }
        catch (RuntimeGoodsException e) {
            log.warn("selectImmediatelyForPlatFrom:gid=" + gid + ",gtype=" + gtype + ",orderId=" + orderId + ",userAgent:" + userAgent + ",hdtoolFalg=" + hdtoolFalg + ",consunmerId=" + consunmerId, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }
}

