/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.remoteservice.item;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.AppItemDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemKeyDto;
import cn.com.duiba.goods.center.api.remoteservice.item.RemoteItemKeyService;
import cn.com.duiba.goods.center.biz.bo.AppItemClassifyRelationBO;
import cn.com.duiba.goods.center.biz.bo.item.ItemKeyBo;
import cn.com.duiba.goods.center.biz.service.item.ItemKeyService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RemoteItemKeyServiceImpl
implements RemoteItemKeyService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteItemKeyServiceImpl.class);
    @Autowired
    private ItemKeyService itemKeyService;
    @Autowired
    private ItemKeyBo itemKeyBo;
    @Autowired
    private AppItemClassifyRelationBO appItemClassifyRelationBO;

    public DubboResult<ItemKeyDto> findItemKey(Long appItemId, Long itemId, Long appId) {
        try {
            ItemKeyDto dto = this.itemKeyService.findItemKey(appItemId, itemId, appId);
            return DubboResult.successResult((Object)dto);
        }
        catch (Exception e) {
            LOGGER.error("findItemKey:appItemId=" + appItemId + " itemId=" + itemId + " appId= " + appId, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Long> findStock(ItemKeyDto itemKeyDto) {
        try {
            Long ret = this.itemKeyService.findStock(itemKeyDto);
            return DubboResult.successResult((Object)ret);
        }
        catch (Exception e) {
            LOGGER.error("findStock:", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> consumeStock(ItemKeyDto itemKeyDto, String bizId, String bizSource) {
        try {
            Boolean ret = this.itemKeyService.consumeStock(itemKeyDto, bizId, bizSource);
            return DubboResult.successResult((Object)ret);
        }
        catch (Exception e) {
            LOGGER.error("consumeStock:", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> rollbackStock(ItemKeyDto itemKeyDto, String bizId, String bizSource) {
        try {
            Boolean ret = this.itemKeyService.rollbackStock(itemKeyDto, bizId, bizSource, new Date());
            return DubboResult.successResult((Object)ret);
        }
        catch (Exception e) {
            LOGGER.error("rollbackStock:", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> rollbackStock(ItemKeyDto itemKeyDto, String bizId, String bizSource, Date bizDate) {
        try {
            Boolean ret = this.itemKeyService.rollbackStock(itemKeyDto, bizId, bizSource, bizDate);
            return DubboResult.successResult((Object)ret);
        }
        catch (Exception e) {
            LOGGER.error("rollbackStock:", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<ItemKeyDto>> findItemKeyByAppItemIds(List<Long> appItemIds, Long appId) {
        try {
            List<ItemKeyDto> dtos = this.itemKeyService.findItemKeyByAppItemIds(appItemIds, appId);
            return DubboResult.successResult(dtos);
        }
        catch (Exception e) {
            LOGGER.error("findItemKeyByAppItemIds:appItemIds=" + appItemIds.toString() + " appId=" + appId, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<ItemKeyDto>> findHomeItemKey(Long appId) {
        return DubboResult.successResult(this.itemKeyBo.findHomeItemKeyCacheList(appId));
    }

    public DubboResult<List<ItemKeyDto>> getBatchItemKeyByAppItemIds(List<Long> appItemIds) {
        return DubboResult.successResult(this.itemKeyBo.getBatchItemKeyByAppItemIds(appItemIds));
    }

    public DubboResult<ItemKeyDto> getItemKey(Long appItemId) {
        return DubboResult.successResult((Object)this.itemKeyBo.getItemKey(appItemId));
    }

    public DubboResult<ItemKeyDto> getItemKey(Long appId, Long itemId) {
        return DubboResult.successResult((Object)this.itemKeyBo.getItemKey(appId, itemId));
    }

    public DubboResult<List<ItemKeyDto>> findItemKeysWithClassifyPayLoad(Long appId, Long classifyId, String status) {
        List<AppItemDto> appItems = this.appItemClassifyRelationBO.findAppItemsWithClassifyPayLoad(classifyId, appId, status);
        return DubboResult.successResult(this.itemKeyBo.transformAppItemList(appItems));
    }

    public DubboResult<ItemKeyDto> findItemKeyIncludeDeleted(Long appItemId, Long itemId, Long appId) {
        try {
            ItemKeyDto dto = this.itemKeyService.findItemKeyIncludeDeleted(appItemId, itemId, appId);
            return DubboResult.successResult((Object)dto);
        }
        catch (Exception e) {
            LOGGER.error("findItemKeyIncludeDeleted:appItemId=" + appItemId + " itemId=" + itemId + " appId=" + appId, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }
}

