/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.service.impl;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.biz.dao.GoodsCouponDao;
import cn.com.duiba.goods.center.biz.entity.GoodsBatchEntity;
import cn.com.duiba.goods.center.biz.entity.GoodsCouponEntity;
import cn.com.duiba.goods.center.biz.service.GoodsCouponService;
import cn.com.duiba.goods.center.biz.service.impl.GoodsCouponServiceImpl;
import cn.com.duiba.goods.center.common.ErrorCode;
import cn.com.duiba.goods.center.common.RedisKeyTool;
import cn.com.duiba.goods.center.common.RuntimeGoodsException;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="goodsCouponService4Speed")
public class GoodsCouponService4Speed
extends GoodsCouponServiceImpl
implements GoodsCouponService {
    private static final int QUEUE_SIZE = 10000;

    @Override
    public Boolean deleteBatchUnusedCoupons(GoodsBatchEntity batch) {
        boolean ret = super.deleteBatchUnusedCoupons(batch);
        this.clearQueueCache(batch.getId());
        return ret;
    }

    @Override
    public Boolean deleteBatchUnusedCoupons(GoodsTypeEnum gtype, long gid, long batchId, List<Long> couponIds) {
        Boolean ret = super.deleteBatchUnusedCoupons(gtype, gid, batchId, couponIds);
        this.clearQueueCache(batchId);
        return ret;
    }

    @Override
    public Boolean deleteUnusedCoupon(GoodsTypeEnum gtype, long gid, long couponId, long batchId) {
        boolean ret = super.deleteUnusedCoupon(gtype, gid, couponId, batchId);
        this.clearQueueCache(batchId);
        return ret;
    }

    @Override
    public Boolean updateLinkBatch(GoodsTypeEnum gtype, long gid, Long batchId, String link) {
        Boolean ret = super.updateLinkBatch(gtype, gid, batchId, link);
        this.clearLinkOrRepeat(batchId);
        return ret;
    }

    @Override
    public void importLinkCoupon(GoodsTypeEnum gtype, long gid, long goodsBatchId, long goodsCouponId, String link) {
        super.importLinkCoupon(gtype, gid, goodsBatchId, goodsCouponId, link);
        this.clearLinkOrRepeat(goodsBatchId);
    }

    @Override
    public void importRepeatCoupon(GoodsTypeEnum gtype, long gid, long goodsBatchId, long goodsCouponId, String code, String password) {
        super.importRepeatCoupon(gtype, gid, goodsBatchId, goodsCouponId, code, password);
        this.clearLinkOrRepeat(goodsBatchId);
    }

    @Override
    public Boolean updateRepeatBatch(GoodsTypeEnum gtype, long gid, Long batchId, String code, String password) {
        Boolean ret = super.updateRepeatBatch(gtype, gid, batchId, code, password);
        this.clearLinkOrRepeat(batchId);
        return ret;
    }

    @Override
    public Integer importNormalCoupons(GoodsBatchEntity batch, List<GoodsCouponDao.CouponFormat> coupons) {
        Integer ret = super.importNormalCoupons(batch, coupons);
        this.clearQueueCache(batch.getId());
        return ret;
    }

    @Override
    public boolean deleteGoodsCoupon(GoodsTypeEnum gtype, long gid, long batchId) {
        boolean ret = super.deleteGoodsCoupon(gtype, gid, batchId);
        this.clearQueueCache(batchId);
        this.clearLinkOrRepeat(batchId);
        return ret;
    }

    @Override
    public int deleteGoodsCouponByIds(long gid, Long batchId, List<Long> ids) {
        int ret = super.deleteGoodsCouponByIds(gid, batchId, ids);
        this.clearQueueCache(batchId);
        return ret;
    }

    @Override
    public GoodsCouponEntity takeNormalCoupon(GoodsTypeEnum gtype, GoodsBatchEntity batch, Long consumerId, Long appId, String bizNum) {
        Boolean consumeSuccess = false;
        try {
            DBTimeProfile.enter((String)"takeNormalCoupon");
            consumeSuccess = this.consumeStocks(gtype, batch, bizNum, appId);
            if (!consumeSuccess.booleanValue()) {
                GoodsCouponEntity goodsCouponEntity = null;
                return goodsCouponEntity;
            }
            GoodsCouponEntity goodsCouponEntity = this.tryTakeCoupon(gtype, batch, consumerId, bizNum, 1);
            return goodsCouponEntity;
        }
        catch (Exception e) {
            if (consumeSuccess.booleanValue()) {
                this.rollbackStocks(gtype, bizNum);
            }
            throw e;
        }
        finally {
            DBTimeProfile.release();
        }
    }

    private GoodsCouponEntity tryTakeCoupon(GoodsTypeEnum gtype, GoodsBatchEntity batch, long consumerId, String bizNum, int count) {
        if (count > 3) {
            throw new RuntimeGoodsException(ErrorCode.E0404002);
        }
        int counter = count + 1;
        try {
            long goodsBatchId = batch.getId();
            long gid = batch.getGid();
            GoodsCouponEntity entity = this.pop(goodsBatchId);
            if (entity == null) {
                this.tryLoadCouponByBatchId(gtype, gid, goodsBatchId, 10000);
                throw new RuntimeGoodsException(ErrorCode.E0404012);
            }
            boolean success = this.takeCoupon4Point(gtype, gid, goodsBatchId, entity.getGoodsCouponId(), consumerId, bizNum);
            if (!success) {
                throw new RuntimeGoodsException(ErrorCode.E0404012);
            }
            return entity;
        }
        catch (RuntimeGoodsException e) {
            boolean retry;
            boolean bl = retry = ErrorCode.E0404012 == e.getErrorCode() || ErrorCode.E0202004 == e.getErrorCode();
            if (retry) {
                return this.tryTakeCoupon(gtype, batch, consumerId, bizNum, counter);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tryLoadCouponByBatchId(GoodsTypeEnum gtype, long gid, long goodsBatchId, int limit) {
        this.queueCheck(goodsBatchId);
        boolean lock = this.redisCacheService.tryGetLock(this.getQueueLockKey(goodsBatchId), 30);
        if (!lock) {
            throw new RuntimeGoodsException(ErrorCode.E0202004);
        }
        this.queueCheck(goodsBatchId);
        try {
            DBTimeProfile.enter((String)"selectCouponAddQueue");
            List<GoodsCouponEntity> list = this.loadCouponByBatchId(gtype, gid, goodsBatchId, limit);
            if (list.isEmpty()) {
                this.setSaleOut(goodsBatchId, true);
                this.goodsBatchService.markBatchStatusUsed(gtype, gid, goodsBatchId);
                throw new RuntimeGoodsException(ErrorCode.E0202005);
            }
            String[] array = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                array[i] = JSONObject.toJSONString((Object)list.get(i));
            }
            this.redisCacheService.addQueue(this.getCouponQueueKey(goodsBatchId), array, 3600);
            this.setSaleOut(goodsBatchId, false);
        }
        finally {
            this.redisCacheService.releaseLock(this.getQueueLockKey(goodsBatchId));
            DBTimeProfile.release();
        }
    }

    private void queueCheck(Long goodsBatchId) {
        if (this.getQueueSize(goodsBatchId) > 0L) {
            throw new RuntimeGoodsException(ErrorCode.E0404012);
        }
        if (this.isSaleOut(goodsBatchId)) {
            throw new RuntimeGoodsException(ErrorCode.E0202005);
        }
    }

    private boolean isSaleOut(long batchId) {
        String value = this.redisCacheService.get(this.getSaleOutKey(batchId));
        if (StringUtils.isEmpty((String)value)) {
            return Boolean.valueOf(value);
        }
        return false;
    }

    private void setSaleOut(long batchId, boolean saleout) {
        this.redisCacheService.set(this.getSaleOutKey(batchId), String.valueOf(saleout), 60);
    }

    private String getSaleOutKey(long batchId) {
        return "goods-" + this.getClass().getSimpleName() + "-saleout-" + batchId;
    }

    public long getQueueSize(long goodsBatchId) {
        return this.redisCacheService.getQueueSize(this.getCouponQueueKey(goodsBatchId));
    }

    public GoodsCouponEntity pop(long goodsBatchId) {
        return (GoodsCouponEntity)JSONObject.parseObject((String)this.redisCacheService.pop(this.getCouponQueueKey(goodsBatchId)), GoodsCouponEntity.class);
    }

    public void clearQueueCache(Long goodsBatchId) {
        String key = this.getCouponQueueKey(goodsBatchId);
        this.redisCacheService.delete(key);
    }

    private String getCouponQueueKey(Long goodsBatchId) {
        return RedisKeyTool.getRedisKey(this.getClass(), (String)"batch_coupons", (String)(goodsBatchId + ""));
    }

    private String getQueueLockKey(Long goodsBatchId) {
        return RedisKeyTool.getRedisKey(this.getClass(), (String)"batch_lock", (String)(goodsBatchId + ""));
    }
}

