/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.service.impl;

import cn.com.duiba.goods.center.biz.remoteservice.impl.RemotePCGFilterConfigBackendServiceImpl;
import cn.com.duiba.goods.center.common.RedisKeyTool;
import com.alibaba.fastjson.JSONObject;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;

class RedisFilterCache {
    private static Logger log = LoggerFactory.getLogger(RemotePCGFilterConfigBackendServiceImpl.class);
    private StringRedisTemplate stringRedisTemplate;

    public RedisFilterCache(StringRedisTemplate stringRedisTemplate) {
        this.stringRedisTemplate = stringRedisTemplate;
    }

    public <T> T getFilterListCache(String key, Class clazz) {
        String string = (String)this.stringRedisTemplate.opsForValue().get((Object)key);
        if (string == null) {
            return null;
        }
        return (T)JSONObject.parseArray((String)string, (Class)clazz);
    }

    public Object getFilterObjectCache(String key) {
        String string = (String)this.stringRedisTemplate.opsForValue().get((Object)key);
        if (string == null) {
            return null;
        }
        return JSONObject.parseObject((String)string);
    }

    public void clearFilterCache(String key) {
        try {
            this.stringRedisTemplate.delete((Object)key);
        }
        catch (Exception e) {
            log.error("RedisBatchCache.clearBatchsCache key=" + key, (Throwable)e);
        }
    }

    public <T> void setFilterCache(String key, T t) {
        String string = JSONObject.toJSONString(t);
        this.stringRedisTemplate.opsForValue().set((Object)key, (Object)string);
        this.stringRedisTemplate.expire((Object)key, 3600L, TimeUnit.SECONDS);
    }

    public String getSellerGoodsRedisKey(String sellerId) {
        return RedisKeyTool.getSellerGoodsRedisKey((String)sellerId);
    }

    public String getCategoryGoodsRedisKey(String categoryId) {
        return RedisKeyTool.getCategoryGoodsRedisKey((String)categoryId);
    }

    public String getPlatformRedisKey(String pcgId) {
        return RedisKeyTool.getPlatformRedisKey((String)pcgId);
    }

    public String getDirectionalRedisKey(Long pcgId, Long appId) {
        return RedisKeyTool.getDirectionalRedisKey((String)(pcgId + "-" + appId));
    }

    public String getFilterConfigRedisKey(Long appId, Integer type) {
        return RedisKeyTool.getDirectionalRedisKey((String)(appId + "-" + type));
    }

    public String getCategoryRedisKey() {
        return RedisKeyTool.getCategoryRedisKey();
    }

    public String getSellerRedisKey() {
        return RedisKeyTool.getSellerRedisKey();
    }
}

