/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.service.impl;

import cn.com.duiba.goods.center.api.remoteservice.dto.SellerDto;
import cn.com.duiba.goods.center.biz.dao.SellerDao;
import cn.com.duiba.goods.center.biz.service.SellerSevice;
import cn.com.duiba.goods.center.biz.util.RedisKeyFactory;
import cn.com.duiba.wolf.cache.AdvancedCacheClient;
import cn.com.duiba.wolf.utils.SecurityUtils;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SellerSeviceImpl
implements SellerSevice {
    @Autowired
    private SellerDao sellerDao;
    @Resource(name="redisTemplate")
    private AdvancedCacheClient advancedCacheClient;
    @Resource(name="stringRedisTemplate03")
    private AdvancedCacheClient memcacheClient;

    @Override
    @Transactional(value="credits")
    public Boolean insertSeller(SellerDto sellerDto) {
        if (sellerDto == null) {
            return false;
        }
        sellerDto.setValidFlag(Integer.valueOf(1));
        this.sellerDao.insertSeller(sellerDto);
        String key = SecurityUtils.encode2StringBySHA((String)(sellerDto.getId() + new Date().toString()));
        sellerDto.setSafeSign(key);
        this.sellerDao.update(sellerDto);
        return true;
    }

    @Override
    public Boolean deleteSeller(Long id) {
        int result = this.sellerDao.deleteSeller(id);
        if (result > 0) {
            this.remove(id);
            return true;
        }
        return false;
    }

    @Override
    public List<SellerDto> findAll(SellerDto sellerDto, Integer offset, Integer max) {
        return this.sellerDao.findAll(sellerDto, offset, max);
    }

    @Override
    public Integer findCount(SellerDto sellerDto) {
        return this.sellerDao.findCount(sellerDto);
    }

    @Override
    public SellerDto findById(Long id) {
        String key = (Object)((Object)RedisKeyFactory.K207) + String.valueOf(id);
        SellerDto sellerDto = (SellerDto)this.advancedCacheClient.get(key);
        if (sellerDto == null) {
            sellerDto = this.sellerDao.findById(id);
            this.advancedCacheClient.set(key, (Object)sellerDto, 60, TimeUnit.SECONDS);
        }
        return sellerDto;
    }

    private void remove(Long id) {
        String key = (Object)((Object)RedisKeyFactory.K207) + String.valueOf(id);
        this.advancedCacheClient.remove(key);
        this.memcacheClient.remove("item.sellerId_" + id);
    }
}

