/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.service.item.impl;

import cn.com.duiba.goods.center.api.remoteservice.dto.AddrLimitDto;
import cn.com.duiba.goods.center.biz.cache.IPCache;
import cn.com.duiba.goods.center.biz.dao.AddrLimitDao;
import cn.com.duiba.goods.center.biz.dao.item.IpLibraryDao;
import cn.com.duiba.goods.center.biz.entity.IpLibraryEntity;
import cn.com.duiba.goods.center.biz.service.RedisCacheService;
import cn.com.duiba.goods.center.biz.service.item.AddrLimitService;
import cn.com.duiba.goods.center.biz.util.RedisKeyFactory;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AddrLimitServiceImpl
implements AddrLimitService {
    @Resource
    private AddrLimitDao addrLimitDao;
    @Autowired
    private IpLibraryDao ipLibraryDao;
    @Autowired
    private RedisCacheService redisCacheService;

    @Override
    public List<AddrLimitDto> findAddrLimitByAppItemId(Long appItemId) {
        return this.addrLimitDao.findAddrLimitByAppItemId(appItemId);
    }

    @Override
    public List<AddrLimitDto> findAddrLimitByItemId(Long itemId) {
        return this.addrLimitDao.findAddrLimitByItemId(itemId);
    }

    @Override
    public Integer findTypeByAppItemId(Long appItemId) {
        return this.addrLimitDao.findTypeByAppItemId(appItemId);
    }

    @Override
    public Integer findTypeByItemId(Long itemId) {
        return this.addrLimitDao.findTypeByItemId(itemId);
    }

    @Override
    public Integer batchInsertAddrLimit(List<AddrLimitDto> addrLimitList) {
        return this.addrLimitDao.batchInsertAddrLimit(addrLimitList);
    }

    @Override
    public Integer deleteAddrLimit(Long itemId, Long appItemId) {
        return this.addrLimitDao.deleteAddrLimit(itemId, appItemId);
    }

    @Override
    public List<AddrLimitDto> findAddrLimitByAppItemIds(List<Long> appItemIds) {
        return this.addrLimitDao.findAddrLimitByAppItemIds(appItemIds);
    }

    @Override
    public List<AddrLimitDto> findAddrLimitByItemIds(List<Long> itemIds) {
        return this.addrLimitDao.findAddrLimitByItemIds(itemIds);
    }

    @Override
    public IPCache findCodeByIpLong(Long ipLong) {
        String key = (Object)((Object)RedisKeyFactory.K203) + String.valueOf(ipLong);
        String value = this.redisCacheService.get(key);
        if (value == null) {
            IpLibraryEntity entity = this.ipLibraryDao.findCodeByIpLong(ipLong);
            if (entity == null) {
                this.redisCacheService.set(key, "NULL", 60);
                return null;
            }
            IPCache cache = new IPCache();
            cache.setCode(entity.getCode());
            cache.setEndIpNum(entity.getEndIpNum());
            this.redisCacheService.set(key, JSONObject.toJSONString((Object)cache), 60);
            return cache;
        }
        if ("NULL".equals(value)) {
            return null;
        }
        return (IPCache)JSONObject.parseObject((String)value, IPCache.class);
    }
}

