/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.service.item.impl;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemKeyDto;
import cn.com.duiba.goods.center.biz.dao.item.CouponBatchDao;
import cn.com.duiba.goods.center.biz.dao.item.CouponDao;
import cn.com.duiba.goods.center.biz.entity.AppItemEntity;
import cn.com.duiba.goods.center.biz.entity.CouponBatchEntity;
import cn.com.duiba.goods.center.biz.entity.ItemEntity;
import cn.com.duiba.goods.center.biz.service.item.AppItemService;
import cn.com.duiba.goods.center.biz.service.item.CouponFlowInnerService;
import cn.com.duiba.goods.center.biz.service.item.ItemService;
import cn.com.duiba.goods.center.common.ErrorCode;
import cn.com.duiba.goods.center.common.RuntimeGoodsException;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CouponFlowInnerServiceImpl
implements CouponFlowInnerService {
    @Autowired
    private CouponBatchDao couponBatchDao;
    @Autowired
    private CouponDao couponDao;
    @Autowired
    private ItemService itemService;
    @Autowired
    private AppItemService appItemService;

    @Override
    public CouponBatchEntity checkCouponBatch(ItemKeyDto itemKey) {
        CouponBatchEntity couponBatch = this.getItemKeyCurrentCouponBatch(itemKey);
        if (couponBatch == null || couponBatch.getRemaining() <= 0) {
            throw new RuntimeGoodsException(ErrorCode.E0202006);
        }
        return couponBatch;
    }

    @Override
    public CouponBatchEntity getItemKeyCurrentCouponBatch(ItemKeyDto itemKey) {
        Long batchId = null;
        if (itemKey.isItemMode() || itemKey.isDuibaAppItemMode()) {
            batchId = itemKey.getItem().getBatchId();
        } else if (itemKey.isSelfAppItemMode()) {
            batchId = itemKey.getAppItem().getBatchId();
        }
        CouponBatchEntity couponBatch = null;
        if (batchId != null) {
            couponBatch = this.couponBatchDao.find(batchId);
        }
        return couponBatch;
    }

    @Override
    @Transactional(value="credits", propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void switchBatch(ItemKeyDto itemKeyDto) {
        if (itemKeyDto.isItemMode() || itemKeyDto.isDuibaAppItemMode()) {
            this.switchItemBatch(itemKeyDto.getItem().getId());
        } else if (itemKeyDto.isSelfAppItemMode()) {
            this.switchAppItemBatch(itemKeyDto.getAppItem().getId());
        }
    }

    @Override
    @Transactional(value="credits", propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void switchItemBatch(long itemId) {
        CouponBatchEntity nextBatch;
        ItemEntity item = this.itemService.find(itemId);
        if (item == null) {
            return;
        }
        if (!"coupon".equals(item.getType())) {
            return;
        }
        if (item.getBatchId() != null) {
            CouponBatchEntity currentBatch = this.couponBatchDao.find(item.getBatchId());
            if (currentBatch.getRemaining() > 0 && currentBatch.getValidEndDate().after(new Date())) {
                return;
            }
            this.refreshBatch(currentBatch);
            this.couponBatchDao.setItemBatchEmpty(itemId);
            nextBatch = this.couponBatchDao.findItemNextBatch(itemId);
        } else {
            nextBatch = this.couponBatchDao.findItemNextBatch(itemId);
        }
        if (nextBatch != null) {
            Integer remaining = this.couponBatchDao.countBatchRemaining(nextBatch.getId());
            this.couponBatchDao.updateActiveAndRemaining(nextBatch.getId(), 1, remaining);
            this.couponBatchDao.setItemBatchId(itemId, nextBatch.getId());
        }
    }

    @Override
    @Transactional(value="credits", propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void switchAppItemBatch(long appItemId) {
        CouponBatchEntity nextBatch;
        AppItemEntity appItem = this.appItemService.find(appItemId);
        if (appItem == null) {
            return;
        }
        if (!"coupon".equals(appItem.getType())) {
            return;
        }
        if (appItem.getBatchId() != null) {
            CouponBatchEntity currentBatch = this.couponBatchDao.find(appItem.getBatchId());
            if (currentBatch.getRemaining() > 0 && currentBatch.getValidEndDate().after(new Date())) {
                return;
            }
            this.refreshBatch(currentBatch);
            this.couponBatchDao.setAppItemBatchEmpty(appItemId);
            nextBatch = this.couponBatchDao.findAppItemNextBatch(appItemId);
        } else {
            nextBatch = this.couponBatchDao.findAppItemNextBatch(appItemId);
        }
        if (nextBatch != null) {
            Integer remaining = this.couponBatchDao.countBatchRemaining(nextBatch.getId());
            this.couponBatchDao.updateActiveAndRemaining(nextBatch.getId(), 1, remaining);
            this.couponBatchDao.setAppItemBatchId(appItemId, nextBatch.getId());
        }
    }

    @Override
    @Transactional(value="credits", propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void refreshBatch(CouponBatchEntity batch) {
        Integer active = batch.getActive();
        if (batch.getValidEndDate().before(new Date())) {
            active = 3;
        }
        Integer remaining = this.couponBatchDao.countBatchRemaining(batch.getId());
        if (2 == batch.getActive() && remaining > 0) {
            active = 0;
        }
        if (remaining <= 0) {
            Integer ret = this.couponDao.ishavingCoupon(batch.getId());
            active = ret == null ? Integer.valueOf(4) : Integer.valueOf(2);
        }
        this.couponBatchDao.updateActiveAndRemaining(batch.getId(), active, remaining);
    }

    @Override
    @Transactional(value="credits", propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void refreshItemKeyCoupon(ItemKeyDto itemKey) {
        if (itemKey.isItemMode() || itemKey.isDuibaAppItemMode()) {
            this.refreshItemCoupon(itemKey.getItem().getId());
        } else if (itemKey.isSelfAppItemMode()) {
            this.refreshAppItemCoupon(itemKey.getAppItem().getId());
        }
    }

    @Override
    @Transactional(value="credits", propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void refreshItemCoupon(long itemId) {
        ItemEntity item = this.itemService.find(itemId);
        if (item == null) {
            return;
        }
        if (!"coupon".equals(item.getType())) {
            return;
        }
        CouponBatchEntity batch = this.couponBatchDao.findItemMaxValidEndDateBatch(itemId);
        Date validEndDate = item.getValidEndDate();
        if (batch != null) {
            validEndDate = batch.getValidEndDate();
            if (batch.getValidEndDate().after(new Date())) {
                this.appItemService.updateExpiedAppItem(itemId);
            }
        }
        Integer totalRemaining = this.couponBatchDao.countAllRemaining(null, itemId);
        this.itemService.updateRemainingAndvalidEndDate(itemId, (long)totalRemaining, validEndDate);
    }

    @Override
    @Transactional(value="credits", propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void refreshAppItemCoupon(long appItemId) {
        AppItemEntity appItem = this.appItemService.find(appItemId);
        if (appItem == null) {
            return;
        }
        if (!"coupon".equals(appItem.getType())) {
            return;
        }
        CouponBatchEntity batch = this.couponBatchDao.findAppItemMaxValidEndDateBatch(appItemId);
        Date validEndDate = appItem.getValidEndDate();
        if (batch != null) {
            validEndDate = batch.getValidEndDate();
            if (batch.getValidEndDate().after(new Date())) {
                this.appItemService.updateExpiedAppItemById(appItemId);
            }
        }
        Integer totalRemaining = this.couponBatchDao.countAllRemaining(appItemId, null);
        this.appItemService.updateRemainingAndvalidEndDate(appItemId, (long)totalRemaining, validEndDate);
    }
}

