/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.service.item.impl;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.AppItemDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemKeyDto;
import cn.com.duiba.goods.center.biz.dao.item.CouponBatchDao;
import cn.com.duiba.goods.center.biz.dao.item.CouponDao;
import cn.com.duiba.goods.center.biz.entity.CouponBatchEntity;
import cn.com.duiba.goods.center.biz.entity.CouponEntity;
import cn.com.duiba.goods.center.biz.service.item.AppItemService;
import cn.com.duiba.goods.center.biz.service.item.CouponFlowInnerService;
import cn.com.duiba.goods.center.biz.service.item.CouponFlowService;
import cn.com.duiba.goods.center.biz.service.item.ItemService;
import cn.com.duiba.goods.center.common.ErrorCode;
import cn.com.duiba.goods.center.common.RuntimeGoodsException;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CouponFlowServiceImpl
implements CouponFlowService {
    @Autowired
    private CouponFlowInnerService couponFlowInnerService;
    @Autowired
    private CouponBatchDao couponBatchDao;
    @Autowired
    private CouponDao couponDao;
    @Autowired
    private ItemService itemService;
    @Autowired
    private AppItemService appItemService;

    @Override
    @Transactional(value="credits", propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public CouponEntity getOneCoupon(ItemKeyDto itemKey) {
        this.couponFlowInnerService.checkCouponBatch(itemKey);
        Long batchId = null;
        AppItemDto appItem = itemKey.getAppItem();
        ItemDto item = itemKey.getItem();
        if (itemKey.isSelfAppItemMode()) {
            batchId = appItem.getBatchId();
        } else if (itemKey.isDuibaAppItemMode() || itemKey.isItemMode()) {
            batchId = item.getBatchId();
        }
        if (batchId == null) {
            throw new RuntimeGoodsException(ErrorCode.E0202006);
        }
        CouponBatchEntity batch = this.couponBatchDao.findForUpdate(batchId);
        if (batch == null || batch.getRemaining() <= 0) {
            throw new RuntimeGoodsException(ErrorCode.E0202006);
        }
        if (batch.getValidEndDate().before(new Date())) {
            this.couponFlowInnerService.switchBatch(itemKey);
            this.couponFlowInnerService.refreshItemKeyCoupon(itemKey);
            return null;
        }
        CouponEntity coupon = this.couponDao.getOneCouponByBatchForUpdate(batch.getId());
        if (coupon != null) {
            int couponRet = this.couponDao.lockCoupon(coupon.getId());
            if (couponRet < 1) {
                throw new RuntimeGoodsException(ErrorCode.E0202006);
            }
            this.couponBatchDao.reduceCouponBatchRemaining(batch.getId());
            if (coupon.getItemId() != null) {
                this.itemService.decrStock(coupon.getItemId());
                this.itemService.removeCache(coupon.getItemId());
            } else if (coupon.getAppItemId() != null && coupon.getItemId() == null) {
                this.appItemService.decrStock(itemKey.getAppId(), coupon.getAppItemId());
                this.appItemService.removeCache(coupon.getAppItemId());
            }
        }
        this.couponFlowInnerService.switchBatch(itemKey);
        this.couponFlowInnerService.refreshItemKeyCoupon(itemKey);
        return coupon;
    }

    @Override
    @Transactional(value="credits", propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void returnOneCoupon(long couponId) {
        CouponEntity coupon = this.couponDao.find(couponId);
        if (!coupon.getLocked().booleanValue()) {
            return;
        }
        CouponBatchEntity couponBatch = this.couponBatchDao.findForUpdate(coupon.getBatchId());
        int ret = this.couponDao.unlockCoupon(couponId);
        if (ret < 1) {
            throw new RuntimeGoodsException(ErrorCode.E0102002);
        }
        this.couponFlowInnerService.refreshBatch(couponBatch);
        if (coupon.getItemId() != null) {
            this.couponFlowInnerService.switchItemBatch(coupon.getItemId());
            this.couponFlowInnerService.refreshItemCoupon(coupon.getItemId());
        } else if (coupon.getAppItemId() != null) {
            this.couponFlowInnerService.switchAppItemBatch(coupon.getAppItemId());
            this.couponFlowInnerService.refreshAppItemCoupon(coupon.getAppItemId());
        }
    }

    @Override
    @Transactional(value="credits", propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void deleteCouponBatch(long batchId) {
        CouponBatchEntity batch = this.couponBatchDao.findForUpdate(batchId);
        if (batch != null && !batch.getActive().equals(4)) {
            this.couponDao.deleteByBatchId(batchId);
            if (batch.getItemId() != null) {
                this.couponFlowInnerService.refreshBatch(batch);
                this.couponFlowInnerService.switchItemBatch(batch.getItemId());
                this.couponFlowInnerService.refreshItemCoupon(batch.getItemId());
            } else if (batch.getAppItemId() != null && batch.getItemId() == null) {
                this.couponFlowInnerService.refreshBatch(batch);
                this.couponFlowInnerService.switchAppItemBatch(batch.getAppItemId());
                this.couponFlowInnerService.refreshAppItemCoupon(batch.getAppItemId());
            }
        }
    }

    @Override
    @Transactional(value="credits", propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public int deleteCouponCode(long couponId) {
        CouponEntity coupon = this.couponDao.find(couponId);
        if (coupon.getLocked().booleanValue() || coupon.getUsed().booleanValue()) {
            return 0;
        }
        CouponBatchEntity couponBatch = this.couponBatchDao.findForUpdate(coupon.getBatchId());
        int ret = this.couponDao.deleteOneCoupon(couponId);
        if (ret < 1) {
            throw new RuntimeGoodsException(ErrorCode.E0102002);
        }
        if (coupon.getItemId() != null) {
            this.couponFlowInnerService.refreshBatch(couponBatch);
            this.couponFlowInnerService.switchItemBatch(coupon.getItemId());
            this.couponFlowInnerService.refreshItemCoupon(coupon.getItemId());
        } else if (coupon.getAppItemId() != null && coupon.getItemId() == null) {
            this.couponFlowInnerService.refreshBatch(couponBatch);
            this.couponFlowInnerService.switchAppItemBatch(coupon.getAppItemId());
            this.couponFlowInnerService.refreshAppItemCoupon(coupon.getAppItemId());
        }
        return ret;
    }

    @Override
    public void completeCoupon(Long couponId, Long orderId) {
        this.couponDao.useCoupon(couponId, orderId);
    }
}

