/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.service.item.impl;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemKeyDto;
import cn.com.duiba.goods.center.biz.dao.item.EverydayLimitDAO;
import cn.com.duiba.goods.center.biz.entity.EverydayLimitEntity;
import cn.com.duiba.goods.center.biz.service.item.EverydayLimitService;
import cn.com.duiba.goods.center.common.ErrorCode;
import cn.com.duiba.goods.center.common.GoodsException;
import cn.com.duiba.wolf.cache.CacheClient;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class EverydayLimitServiceImpl
implements EverydayLimitService {
    private static Logger log = LoggerFactory.getLogger(EverydayLimitServiceImpl.class);
    private static final String ITEM_NAMESPACE = "itemcache";
    private static final String APPITEM_NAMESPACE = "appitemcache";
    @Autowired
    private EverydayLimitDAO everydayLimitDAO;
    @Autowired
    private CacheClient cacheClient;
    @Resource(name="stringRedisTemplate03")
    private StringRedisTemplate stringRedisTemplate;

    @Override
    public Boolean isEverydayLimit(ItemKeyDto itemKeyDto) {
        if (itemKeyDto.isItemMode()) {
            return itemKeyDto.getItem().isOpTypeItem(1);
        }
        if (itemKeyDto.isDuibaAppItemMode()) {
            if (itemKeyDto.getAppItem().isOpTypeAppItem(1)) {
                return true;
            }
            if (itemKeyDto.getItem().isOpTypeItem(1)) {
                return true;
            }
        } else if (itemKeyDto.isSelfAppItemMode()) {
            return itemKeyDto.getAppItem().isOpTypeAppItem(1);
        }
        return false;
    }

    @Override
    public Long findEverydayStock(ItemKeyDto itemKeyDto) {
        if (!this.isEverydayLimit(itemKeyDto).booleanValue()) {
            return null;
        }
        Integer limit = this.getLimit(itemKeyDto);
        if (limit == null) {
            return null;
        }
        Integer sales = this.findEverydayLimitSales(itemKeyDto);
        Integer stock = 0;
        if (sales < limit) {
            stock = limit - sales;
        }
        return (long)stock;
    }

    @Override
    public Boolean decrEeverydayStock(ItemKeyDto itemKeyDto) throws GoodsException {
        if (!this.isEverydayLimit(itemKeyDto).booleanValue()) {
            return null;
        }
        Integer limit = this.getLimit(itemKeyDto);
        if (limit == null) {
            return null;
        }
        Long appItemId = itemKeyDto.getAppItem() == null ? 0L : itemKeyDto.getAppItem().getId();
        Long itemId = itemKeyDto.getItem() == null ? 0L : itemKeyDto.getItem().getId();
        boolean ret = this.updateEverydaySales(appItemId, itemId, limit);
        this.deleteEverydayCache(itemKeyDto);
        return ret;
    }

    @Override
    public Boolean incrEverydayStock(ItemKeyDto itemKeyDto) {
        if (!this.isEverydayLimit(itemKeyDto).booleanValue()) {
            return null;
        }
        Long appItemId = itemKeyDto.getAppItem() == null ? 0L : itemKeyDto.getAppItem().getId();
        Long itemId = itemKeyDto.getItem() == null ? 0L : itemKeyDto.getItem().getId();
        this.rollbackEverydayLimit(appItemId, itemId);
        this.deleteEverydayCache(itemKeyDto);
        return true;
    }

    private Integer getLimit(ItemKeyDto itemKey) {
        Integer limit = null;
        if (itemKey.isItemMode()) {
            limit = itemKey.getItem().getLimitEverydayQuantity();
        } else if (itemKey.isDuibaAppItemMode()) {
            if (itemKey.getItem().isOpTypeItem(1)) {
                limit = itemKey.getItem().getLimitEverydayQuantity();
            } else if (itemKey.getAppItem().isOpTypeAppItem(1)) {
                limit = itemKey.getAppItem().getLimitEverydayQuantity();
            }
        } else if (itemKey.isSelfAppItemMode()) {
            limit = itemKey.getAppItem().getLimitEverydayQuantity();
        }
        return limit;
    }

    @Override
    public boolean updateEverydaySales(Long appItemId, Long itemId, int limit) throws GoodsException {
        int ret;
        Long item;
        Date day = new Date();
        Long appItem = appItemId == null ? 0L : appItemId;
        EverydayLimitEntity everyday = this.everydayLimitDAO.find(appItem, item = Long.valueOf(itemId == null ? 0L : itemId), day);
        if (everyday == null) {
            everyday = new EverydayLimitEntity();
            everyday.setAppItemId(appItem);
            everyday.setItemId(item);
            everyday.setSales(0);
            everyday.setDay(day);
            try {
                this.everydayLimitDAO.insert(everyday);
            }
            catch (DuplicateKeyException e) {
                log.warn("everydayLimitCheck unique:appItemId:" + appItemId + " itemId:" + itemId + " day:" + new SimpleDateFormat("yyyy-MM-dd").format(day), (Throwable)e);
            }
        }
        if ((ret = this.everydayLimitDAO.updateSales(everyday.getId(), limit)) < 1) {
            throw new GoodsException(ErrorCode.E0404011.getErrorCode(), "\u6bcf\u65e5\u9650\u91cf\u5e93\u5b58\u4e0d\u8db3");
        }
        return true;
    }

    @Override
    public void rollbackEverydayLimit(Long appItemId, Long itemId) {
        Long item;
        Date day = new Date();
        Long appItem = appItemId == null ? 0L : appItemId;
        EverydayLimitEntity everyday = this.everydayLimitDAO.find(appItem, item = Long.valueOf(itemId == null ? 0L : itemId), day);
        if (everyday == null) {
            return;
        }
        this.everydayLimitDAO.rollbackSales(everyday.getId());
    }

    @Override
    public Integer findEverydayLimitSales(Long appItemId, Long itemId) {
        Long item;
        Date day = new Date();
        Long appItem = appItemId == null ? 0L : appItemId;
        EverydayLimitEntity everyday = this.everydayLimitDAO.find(appItem, item = Long.valueOf(itemId == null ? 0L : itemId), day);
        if (everyday == null) {
            return 0;
        }
        return everyday.getSales();
    }

    @Override
    public Integer findEverydayLimitSales(ItemKeyDto itemKeyDto) {
        Long appItemId = itemKeyDto.getAppItem() == null ? 0L : itemKeyDto.getAppItem().getId();
        Long itemId = itemKeyDto.getItem() == null ? 0L : itemKeyDto.getItem().getId();
        return this.findEverydayLimitSales(appItemId, itemId);
    }

    private void deleteEverydayCache(ItemKeyDto itemKey) {
        try {
            String key = this.getKey(itemKey);
            this.cacheClient.remove(key);
            this.stringRedisTemplate.delete((Object)key);
        }
        catch (Exception e) {
            log.error("deleteEverydayCache", (Throwable)e);
        }
    }

    private String getKey(ItemKeyDto itemKey) {
        String key = null;
        if (itemKey.isItemMode()) {
            key = ITEM_NAMESPACE + itemKey.getItem().getId();
        } else if (itemKey.isDuibaAppItemMode()) {
            if (itemKey.getItem().isOpTypeItem(1)) {
                key = ITEM_NAMESPACE + itemKey.getItem().getId();
            } else if (itemKey.getAppItem().isOpTypeAppItem(1)) {
                key = APPITEM_NAMESPACE + itemKey.getAppItem().getId();
            }
        } else if (itemKey.isSelfAppItemMode()) {
            key = APPITEM_NAMESPACE + itemKey.getAppItem().getId();
        }
        return key;
    }
}

