/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.service.item.impl;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.dto.ElasticGiftsItemShowDto;
import cn.com.duiba.goods.center.biz.dao.item.ItemDao;
import cn.com.duiba.goods.center.biz.entity.GoodsLimitRecordEntity;
import cn.com.duiba.goods.center.biz.entity.ItemEntity;
import cn.com.duiba.goods.center.biz.service.GoodsLimitRecordService;
import cn.com.duiba.goods.center.biz.service.item.ItemGoodsService;
import cn.com.duiba.goods.center.biz.service.item.ItemService;
import cn.com.duiba.goods.center.biz.service.item.PreStockService;
import cn.com.duiba.goods.center.common.ErrorCode;
import cn.com.duiba.goods.center.common.GoodsException;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="itemGoodsService")
public class ItemGoodsServiceImpl
implements ItemGoodsService {
    @Autowired
    private ItemDao itemDao;
    @Autowired
    private GoodsLimitRecordService goodsLimitRecordService;
    @Autowired
    private PreStockService preStockService;
    @Autowired
    private ItemService itemService;

    @Override
    public List<ElasticGiftsItemShowDto> getItemsByElItemIds4Mobile(List<Long> itemIds, Long appId, Long consumerId) throws GoodsException {
        List<ItemEntity> items = this.getItemWithoutConsumerWithCache(itemIds, appId);
        this.itemLimitFilter(items, consumerId);
        ArrayList<ElasticGiftsItemShowDto> result = new ArrayList<ElasticGiftsItemShowDto>();
        for (ItemEntity it : items) {
            result.add(new ElasticGiftsItemShowDto(it.getId(), it.getWhiteImage()));
        }
        return result;
    }

    @Override
    public void checkElasticTakeOrder(Long itemId, Long appId, Long consumerId) throws GoodsException {
        Preconditions.checkNotNull((Object)itemId, (Object)"\u5151\u6362\u9879\u53c2\u6570\u4e0d\u5168");
        Preconditions.checkNotNull((Object)appId, (Object)"app\u53c2\u6570\u4e0d\u5168");
        Preconditions.checkNotNull((Object)consumerId, (Object)"\u7528\u6237\u53c2\u6570\u4e0d\u5168");
        ItemEntity item = this.itemService.findCorrectStockItem(itemId);
        if (item == null || item.getDeleted().booleanValue()) {
            throw new GoodsException(ErrorCode.E9999999.getErrorCode(), "\u5151\u6362\u9879\u4e0d\u5b58\u5728");
        }
        if (!item.getEnable().booleanValue()) {
            throw new GoodsException(ErrorCode.E9999999.getErrorCode(), "\u5151\u6362\u9879\u672a\u542f\u7528");
        }
        Long stock = this.preStockService.getPreStock(item, appId);
        if (stock == null) {
            stock = (long)item.getRemaining();
        }
        if (stock <= 0L) {
            throw new GoodsException(ErrorCode.E0202006.getErrorCode(), "\u5e93\u5b58\u4e0d\u8db3");
        }
        int countRecord = this.goodsLimitRecordService.findCount(GoodsTypeEnum.DUIBA.getGtype(), itemId, consumerId);
        if (countRecord == 0) {
            return;
        }
        throw new GoodsException(ErrorCode.E9999999.getErrorCode(), "\u7528\u6237\u5151\u6362\u8d85\u8fc7\u9650\u5236");
    }

    private void itemLimitFilter(List<ItemEntity> items, Long consumerId) {
        if (CollectionUtils.isEmpty(items)) {
            return;
        }
        ArrayList<Long> itemIds = new ArrayList<Long>(items.size());
        for (ItemEntity it : items) {
            itemIds.add(it.getId());
        }
        List<GoodsLimitRecordEntity> limitRecords = this.goodsLimitRecordService.findCounts(GoodsTypeEnum.DUIBA.getGtype(), itemIds, consumerId);
        HashMap<Long, GoodsLimitRecordEntity> limitMap = new HashMap<Long, GoodsLimitRecordEntity>();
        for (GoodsLimitRecordEntity it : limitRecords) {
            limitMap.put(it.getGid(), it);
        }
        Iterator<ItemEntity> iterator = items.iterator();
        while (iterator.hasNext()) {
            ItemEntity entity = iterator.next();
            GoodsLimitRecordEntity limit = (GoodsLimitRecordEntity)limitMap.get(entity.getId());
            if (limit == null || limit.getCount() == 0) continue;
            iterator.remove();
        }
    }

    private List<ItemEntity> getItemWithoutConsumerWithCache(List<Long> ids, Long appId) throws GoodsException {
        return this.getItemWithoutConsumer(ids);
    }

    private List<ItemEntity> getItemWithoutConsumer(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        List<ItemEntity> items = this.itemDao.findAllByIds(ids);
        if (CollectionUtils.isEmpty(items)) {
            return Collections.emptyList();
        }
        ArrayList<ItemEntity> result = new ArrayList<ItemEntity>();
        for (ItemEntity it : items) {
            if (!it.getEnable().booleanValue() || !it.isOpTypeItem(2) || !"coupon".equals(it.getType()) || 1 != it.getSubType()) continue;
            result.add(it);
        }
        return result;
    }

    @Override
    public ItemEntity find(Long itemId) {
        return this.itemDao.find(itemId);
    }

    @Override
    public Boolean updateEnable(Long itemId, Boolean enable) {
        int ret = this.itemDao.updateEnable(itemId, enable);
        if (ret > 0) {
            return true;
        }
        return false;
    }
}

