/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.service.item.impl;

import cn.com.duiba.goods.center.api.remoteservice.dto.item.AppItemDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemKeyDto;
import cn.com.duiba.goods.center.biz.dao.item.ItemAppSpecifyDao;
import cn.com.duiba.goods.center.biz.dao.item.ItemStockConsumeDao;
import cn.com.duiba.goods.center.biz.dao.item.ItemStockSpecifyConsumeDao;
import cn.com.duiba.goods.center.biz.dao.item.PreStockConsumeDetailDao;
import cn.com.duiba.goods.center.biz.dao.item.PreStockDao;
import cn.com.duiba.goods.center.biz.dao.item.PreStockPointDao;
import cn.com.duiba.goods.center.biz.entity.ItemAppSpecifyEntity;
import cn.com.duiba.goods.center.biz.entity.ItemEntity;
import cn.com.duiba.goods.center.biz.entity.ItemStockConsumeEntity;
import cn.com.duiba.goods.center.biz.entity.ItemStockSpecifyConsumeEntity;
import cn.com.duiba.goods.center.biz.entity.PreStockConsumeDetailEntity;
import cn.com.duiba.goods.center.biz.entity.PreStockEntity;
import cn.com.duiba.goods.center.biz.entity.PreStockPointEntity;
import cn.com.duiba.goods.center.biz.service.item.AppItemService;
import cn.com.duiba.goods.center.biz.service.item.EverydayLimitService;
import cn.com.duiba.goods.center.biz.service.item.ItemKeyStockService;
import cn.com.duiba.goods.center.biz.service.item.ItemService;
import cn.com.duiba.goods.center.biz.service.item.PreStockService;
import cn.com.duiba.goods.center.biz.service.stock.MemStockService;
import cn.com.duiba.goods.center.common.ErrorCode;
import cn.com.duiba.goods.center.common.GoodsException;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@Service
public class ItemKeyStockServiceImpl
implements ItemKeyStockService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ItemKeyStockServiceImpl.class);
    @Autowired
    private AppItemService appItemService;
    @Autowired
    private ItemService itemService;
    @Autowired
    private MemStockService memStockService;
    @Autowired
    private PreStockService preStockService;
    @Autowired
    private ItemStockConsumeDao itemStockConsumeDao;
    @Autowired
    private ItemAppSpecifyDao itemAppSpecifyDao;
    @Autowired
    private ItemStockSpecifyConsumeDao itemStockSpecifyConsumeDao;
    @Autowired
    private PreStockDao preStockDao;
    @Autowired
    private PreStockPointDao preStockPointDao;
    @Autowired
    private PreStockConsumeDetailDao preStockConsumeDetailDao;
    @Autowired
    private EverydayLimitService everydayLimitService;
    @Resource(name="creditsTransactionManager")
    private DataSourceTransactionManager creditsTransactionManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean decrStock(ItemKeyDto itemKeyDto, String bizId, String bizSource) throws GoodsException {
        try {
            DBTimeProfile.enter((String)"decrStock");
            if (!itemKeyDto.getItemDtoType().equals("object") && !itemKeyDto.getItemDtoType().equals("virtual")) {
                throw new GoodsException(ErrorCode.E0404004.getErrorCode(), "\u4e0d\u652f\u6301\u8be5\u7c7b\u578b\uff1a" + itemKeyDto.getItemDtoType());
            }
            if (itemKeyDto.isSelfAppItemMode()) {
                AppItemDto appItemDto = itemKeyDto.getAppItem();
                if (appItemDto.getRemaining() == null || appItemDto.getRemaining() <= 0) {
                    throw new GoodsException(ErrorCode.E0202006.getErrorCode(), "\u5e93\u5b58\u4e0d\u8db3");
                }
                this.decrAppItemStock(appItemDto.getAppId(), appItemDto.getId(), bizId, bizSource);
                Boolean bl = true;
                return bl;
            }
            if (itemKeyDto.isItemMode() || itemKeyDto.isDuibaAppItemMode()) {
                ItemDto itemDto = itemKeyDto.getItem();
                if (itemDto.getRemaining() == null || itemDto.getRemaining() <= 0) {
                    throw new GoodsException(ErrorCode.E0202006.getErrorCode(), "\u5e93\u5b58\u4e0d\u8db3");
                }
                this.decrItemStock(itemKeyDto.getAppId(), itemDto.getId(), bizId, bizSource);
                Boolean bl = true;
                return bl;
            }
            Boolean bl = false;
            return bl;
        }
        finally {
            DBTimeProfile.release();
        }
    }

    private void decrAppItemStock(Long appId, Long appItemId, String bizId, String bizSource) throws GoodsException {
        TransactionStatus status = this.creditsTransactionManager.getTransaction((TransactionDefinition)new DefaultTransactionDefinition());
        try {
            boolean ret = this.appItemService.decrStock(appId, appItemId);
            if (!ret) {
                throw new GoodsException(ErrorCode.E0202006.getErrorCode(), "\u5e93\u5b58\u4e0d\u8db3");
            }
            Date now = new Date(System.currentTimeMillis() / 1000L * 1000L);
            ItemStockConsumeEntity consume = new ItemStockConsumeEntity();
            consume.setBizId(bizId);
            consume.setBizSource(bizSource);
            consume.setRelationId(appItemId);
            consume.setRelationType("appItem");
            consume.setAppId(appId);
            consume.setAction("pay");
            consume.setQuantity(1L);
            consume.setGmtCreate(now);
            consume.setGmtModified(now);
            this.itemStockConsumeDao.insert(consume);
        }
        catch (DuplicateKeyException e) {
            status.setRollbackOnly();
            throw new GoodsException(ErrorCode.E0404011.getErrorCode(), "\u91cd\u590d\u6263\u5e93\u5b58");
        }
        catch (Exception e) {
            status.setRollbackOnly();
            throw e;
        }
        finally {
            this.creditsTransactionManager.commit(status);
        }
        this.appItemService.removeCache(appItemId);
    }

    private void decrItemStock(Long appId, Long itemId, String bizId, String bizSource) throws GoodsException {
        TransactionStatus status = this.creditsTransactionManager.getTransaction((TransactionDefinition)new DefaultTransactionDefinition());
        try {
            boolean ret = this.itemService.decrStock(itemId);
            if (!ret) {
                throw new GoodsException(ErrorCode.E0202006.getErrorCode(), "\u5e93\u5b58\u4e0d\u8db3");
            }
            Date now = new Date(System.currentTimeMillis() / 1000L * 1000L);
            ItemStockConsumeEntity consume = new ItemStockConsumeEntity();
            consume.setBizId(bizId);
            consume.setBizSource(bizSource);
            consume.setRelationId(itemId);
            consume.setRelationType("item");
            consume.setAppId(appId);
            consume.setAction("pay");
            consume.setQuantity(1L);
            consume.setGmtCreate(now);
            consume.setGmtModified(now);
            this.itemStockConsumeDao.insert(consume);
        }
        catch (DuplicateKeyException e) {
            status.setRollbackOnly();
            throw new GoodsException(ErrorCode.E0404011.getErrorCode(), "\u91cd\u590d\u6263\u5e93\u5b58");
        }
        catch (Exception e) {
            status.setRollbackOnly();
            throw e;
        }
        finally {
            this.creditsTransactionManager.commit(status);
        }
        this.itemService.removeCache(itemId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean decrAppSpecifyStock(Long appId, ItemEntity itemEntity, String bizId, String bizSource) throws GoodsException {
        try {
            DBTimeProfile.enter((String)"decrAppSpecifyStock");
            if (!"object".equals(itemEntity.getType()) && !"coupon".equals(itemEntity.getType())) {
                Boolean bl = false;
                return bl;
            }
            if (!itemEntity.isOpTypeItem(3)) {
                Boolean bl = false;
                return bl;
            }
            ItemAppSpecifyEntity specify = this.itemAppSpecifyDao.findByItemIdAndAppId(itemEntity.getId(), appId);
            if (null == specify) {
                Boolean bl = false;
                return bl;
            }
            if (specify.getRemaining() <= 0) {
                throw new GoodsException(ErrorCode.E0202006.getErrorCode(), "\u5b9a\u5411\u5e93\u5b58\u4e0d\u8db3");
            }
            TransactionStatus status = this.creditsTransactionManager.getTransaction((TransactionDefinition)new DefaultTransactionDefinition());
            try {
                int row = this.itemAppSpecifyDao.reduceRemaining(itemEntity.getId(), appId);
                if (row < 1) {
                    throw new GoodsException(ErrorCode.E0202006.getErrorCode(), "\u5b9a\u5411\u5e93\u5b58\u4e0d\u8db3");
                }
                Date now = new Date(System.currentTimeMillis() / 1000L * 1000L);
                ItemStockSpecifyConsumeEntity consume = new ItemStockSpecifyConsumeEntity();
                consume.setBizId(bizId);
                consume.setBizSource(bizSource);
                consume.setRelationId(itemEntity.getId());
                consume.setRelationType("item");
                consume.setAppId(appId);
                consume.setAction("pay");
                consume.setQuantity(1L);
                consume.setGmtCreate(now);
                consume.setGmtModified(now);
                this.itemStockSpecifyConsumeDao.insert(consume);
            }
            catch (DuplicateKeyException e) {
                status.setRollbackOnly();
                throw new GoodsException(ErrorCode.E0404011.getErrorCode(), "\u91cd\u590d\u6263\u5b9a\u5411\u5e93\u5b58");
            }
            catch (Exception e) {
                status.setRollbackOnly();
                throw e;
            }
            finally {
                this.creditsTransactionManager.commit(status);
            }
            Boolean bl = true;
            return bl;
        }
        finally {
            DBTimeProfile.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean decrPreStock(Long appId, Long itemId, PreStockPointEntity pointStock, String bizId, String bizSource) throws GoodsException {
        try {
            DBTimeProfile.enter((String)"decrPreStock");
            PreStockEntity preStock = this.preStockDao.findByPointId(pointStock.getId());
            if (null == preStock) {
                throw new GoodsException(ErrorCode.E0404004.getErrorCode(), "\u5546\u54c1\u65e0\u9884\u5206\u914d\u5e93\u5b58");
            }
            if (preStock.getStock() < 1L) {
                throw new GoodsException(ErrorCode.E0202006.getErrorCode(), "\u9884\u5206\u914d\u5e93\u5b58\u4e0d\u8db3");
            }
            this.decrPreEveryday(pointStock);
            TransactionStatus status = this.creditsTransactionManager.getTransaction((TransactionDefinition)new DefaultTransactionDefinition());
            try {
                boolean success = this.preStockDao.reduceQuantity(preStock.getId(), 1L);
                if (!success) {
                    throw new GoodsException(ErrorCode.E0202006.getErrorCode(), "\u9884\u5206\u914d\u5e93\u5b58\u4e0d\u8db3");
                }
                PreStockConsumeDetailEntity detail = new PreStockConsumeDetailEntity();
                detail.setBizId(bizId);
                detail.setAction("pay");
                detail.setPointId(pointStock.getId());
                detail.setStockId(preStock.getId());
                detail.setQuantity(1L);
                detail.setAppId(appId);
                Date now = new Date(System.currentTimeMillis() / 1000L * 1000L);
                detail.setGmtCreate(now);
                detail.setGmtModified(now);
                this.preStockConsumeDetailDao.insert(detail);
            }
            catch (DuplicateKeyException e) {
                status.setRollbackOnly();
                throw new GoodsException(ErrorCode.E0404011.getErrorCode(), "\u91cd\u590d\u6263\u9884\u5206\u5e93\u5b58");
            }
            catch (Exception e) {
                status.setRollbackOnly();
                throw e;
            }
            finally {
                this.creditsTransactionManager.commit(status);
            }
            this.preStockService.deletePreStockCounter(pointStock.getId());
            Boolean bl = true;
            return bl;
        }
        finally {
            DBTimeProfile.release();
        }
    }

    private void decrPreEveryday(PreStockPointEntity pointStock) throws GoodsException {
        boolean limit;
        if (pointStock == null) {
            return;
        }
        if (pointStock.getLimitEverydayQuantity() != null && !(limit = this.memStockService.consumeEverydayStock(pointStock.getId().toString(), pointStock.getLimitEverydayQuantity()))) {
            throw new GoodsException(ErrorCode.E0202006.getErrorCode(), "\u9884\u5206\u914d\u6bcf\u65e5\u9650\u91cf\u5e93\u5b58\u4e0d\u8db3");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Boolean rollbackStock(String bizId, String bizSource) {
        try {
            ItemStockConsumeEntity consume = this.itemStockConsumeDao.findByBizIdAndSource(bizId, bizSource);
            if (null == consume) {
                return false;
            }
            TransactionStatus status = this.creditsTransactionManager.getTransaction((TransactionDefinition)new DefaultTransactionDefinition());
            try {
                boolean back;
                if (consume.getRelationType().equals("appItem")) {
                    back = this.appItemService.incrStock(consume.getRelationId());
                    if (!back) {
                        LOGGER.info("rollbackStock:appItemId= " + consume.getRelationId() + " \u8fd4\u8fd8\u5e93\u5b58\u5931\u8d25");
                        Boolean bl = false;
                        return bl;
                    }
                } else if (consume.getRelationType().equals("item") && !(back = this.itemService.incrStock(consume.getRelationId()).booleanValue())) {
                    LOGGER.info("rollbackStock:itemId= " + consume.getRelationId() + " \u8fd4\u8fd8\u5e93\u5b58\u5931\u8d25");
                    Boolean bl = false;
                    return bl;
                }
                Date now = new Date(System.currentTimeMillis() / 1000L * 1000L);
                ItemStockConsumeEntity detail = new ItemStockConsumeEntity();
                detail.setBizId(consume.getBizId());
                detail.setBizSource(consume.getBizSource());
                detail.setRelationId(consume.getRelationId());
                detail.setRelationType(consume.getRelationType());
                detail.setAppId(consume.getAppId());
                detail.setAction("back");
                detail.setQuantity(1L);
                detail.setGmtCreate(now);
                detail.setGmtModified(now);
                this.itemStockConsumeDao.insert(detail);
                return true;
            }
            catch (Exception e) {
                status.setRollbackOnly();
                throw e;
            }
            finally {
                this.creditsTransactionManager.commit(status);
            }
        }
        catch (Exception e) {
            LOGGER.error("rollbackStock:bizId=" + bizId + " \u8fd4\u8fd8\u5e93\u5b58\u5f02\u5e38", (Throwable)e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Boolean rollbackAppSpecifyStock(String bizId, String bizSource) {
        try {
            ItemStockSpecifyConsumeEntity consume = this.itemStockSpecifyConsumeDao.findByBizIdAndSource(bizId, bizSource);
            if (null == consume) {
                return false;
            }
            ItemAppSpecifyEntity specify = this.itemAppSpecifyDao.findByItemIdAndAppId(consume.getRelationId(), consume.getAppId());
            if (null == specify) {
                return false;
            }
            TransactionStatus status = this.creditsTransactionManager.getTransaction((TransactionDefinition)new DefaultTransactionDefinition());
            try {
                int row = this.itemAppSpecifyDao.increaseRemaining(specify.getItemId(), specify.getAppId());
                if (row < 1) {
                    LOGGER.info("rollbackAppSpecifyStock:bizId=" + bizId + " \u8fd4\u8fd8\u5b9a\u5411\u5e93\u5b58\u5931\u8d25");
                    Boolean bl = false;
                    return bl;
                }
                Date now = new Date(System.currentTimeMillis() / 1000L * 1000L);
                ItemStockSpecifyConsumeEntity detail = new ItemStockSpecifyConsumeEntity();
                detail.setBizId(bizId);
                detail.setBizSource(bizSource);
                detail.setRelationId(consume.getRelationId());
                detail.setRelationType(consume.getRelationType());
                detail.setAppId(consume.getAppId());
                detail.setAction("back");
                detail.setQuantity(consume.getQuantity());
                detail.setGmtCreate(now);
                detail.setGmtModified(now);
                this.itemStockSpecifyConsumeDao.insert(detail);
                return true;
            }
            catch (Exception e) {
                status.setRollbackOnly();
                throw e;
            }
            finally {
                this.creditsTransactionManager.commit(status);
            }
        }
        catch (Exception e) {
            LOGGER.error("rollbackAppSpecifyStock:bizId=" + bizId + " \u8fd4\u8fd8\u5b9a\u5411\u5e93\u5b58\u5f02\u5e38", (Throwable)e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Boolean rollbackPreStock(String bizId) {
        try {
            PreStockConsumeDetailEntity consume = this.preStockConsumeDetailDao.findByBizIdAndPayAction(bizId);
            if (null == consume) {
                return false;
            }
            TransactionStatus status = this.creditsTransactionManager.getTransaction((TransactionDefinition)new DefaultTransactionDefinition());
            try {
                boolean success = this.preStockDao.addQuantity(consume.getStockId(), 1L);
                if (!success) {
                    LOGGER.info("rollbackPreStock:bizId=" + bizId + " \u8fd4\u8fd8\u9884\u5206\u914d\u5e93\u5b58\u5931\u8d25");
                    Boolean bl = false;
                    return bl;
                }
                Date now = new Date(System.currentTimeMillis() / 1000L * 1000L);
                PreStockConsumeDetailEntity detail = new PreStockConsumeDetailEntity();
                detail.setBizId(bizId);
                detail.setAction("back");
                detail.setPointId(consume.getPointId());
                detail.setStockId(consume.getStockId());
                detail.setQuantity(consume.getQuantity());
                detail.setAppId(consume.getAppId());
                detail.setGmtCreate(now);
                detail.setGmtModified(now);
                this.preStockConsumeDetailDao.insert(detail);
            }
            catch (Exception e) {
                status.setRollbackOnly();
                throw e;
            }
            finally {
                this.creditsTransactionManager.commit(status);
            }
            this.preStockService.deletePreStockCounter(consume.getPointId());
            return true;
        }
        catch (Exception e) {
            LOGGER.error("rollbackPreStock:bizId=" + bizId + " \u8fd4\u8fd8\u9884\u5206\u914d\u5e93\u5b58\u5f02\u5e38", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean decrEverydayStock(ItemKeyDto itemKeyDto) throws GoodsException {
        try {
            DBTimeProfile.enter((String)"decrEverydayStock");
            if (!this.everydayLimitService.isEverydayLimit(itemKeyDto).booleanValue()) {
                Boolean bl = false;
                return bl;
            }
            Boolean bl = this.everydayLimitService.decrEeverydayStock(itemKeyDto);
            return bl;
        }
        finally {
            DBTimeProfile.release();
        }
    }

    @Override
    public Boolean rollbackEverydayStock(ItemKeyDto itemKeyDto) {
        try {
            return this.everydayLimitService.incrEverydayStock(itemKeyDto);
        }
        catch (Exception e) {
            LOGGER.error("rollbackEverydayStock:\u8fd4\u8fd8\u6bcf\u65e5\u9650\u91cf\u5e93\u5b58\u5f02\u5e38", (Throwable)e);
            return false;
        }
    }
}

