/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.goods.center.biz.service.item.impl;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.goods.center.api.remoteservice.dto.GoodsStockDto;
import cn.com.duiba.goods.center.api.remoteservice.dto.item.ItemDto;
import cn.com.duiba.goods.center.biz.bo.GoodsCouponBO;
import cn.com.duiba.goods.center.biz.cache.EventHomeCache;
import cn.com.duiba.goods.center.biz.dao.item.AppItemMaskDao;
import cn.com.duiba.goods.center.biz.dao.item.ItemAppSpecifyDao;
import cn.com.duiba.goods.center.biz.dao.item.ItemAutoRecommendDao;
import cn.com.duiba.goods.center.biz.dao.item.ItemDao;
import cn.com.duiba.goods.center.biz.entity.ItemEntity;
import cn.com.duiba.goods.center.biz.service.GoodsBatchService;
import cn.com.duiba.goods.center.biz.service.RedisCacheService;
import cn.com.duiba.goods.center.biz.service.item.ItemService;
import cn.com.duiba.goods.center.biz.service.item.PreStockService;
import cn.com.duiba.goods.center.biz.util.RedisKeyFactory;
import cn.com.duiba.goods.center.common.ErrorCode;
import cn.com.duiba.goods.center.common.RuntimeGoodsException;
import cn.com.duiba.wolf.cache.AdvancedCacheClient;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@Service(value="itemService")
public class ItemServiceImpl
implements ItemService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ItemServiceImpl.class);
    @Autowired
    private RedisCacheService redisCacheService;
    @Autowired
    private ItemDao itemDao;
    @Autowired
    private ItemAppSpecifyDao itemAppSpecifyDao;
    @Autowired
    private GoodsCouponBO goodsCouponBO;
    @Autowired
    private GoodsBatchService goodsBatchService;
    @Autowired
    private PreStockService preStockService;
    @Autowired
    private ItemAutoRecommendDao itemAutoRecommendDao;
    @Autowired
    private AppItemMaskDao appItemMaskDao;
    @Resource(name="creditsTransactionManager")
    private DataSourceTransactionManager creditsTransactionManager;
    @Resource
    private EventHomeCache eventHomeCache;
    @Resource(name="stringRedisTemplate03")
    private AdvancedCacheClient advancedCacheClient;

    private String getCacheKeyById(Long id) {
        return "item.itemId_" + id;
    }

    @Override
    public ItemEntity findCorrectStockItem(Long id) {
        Preconditions.checkNotNull((Object)id, (Object)"id \u4e0d\u80fd\u4e3a null");
        ItemEntity item = this.itemDao.find(id);
        if (item == null) {
            return null;
        }
        if (item.isOpTypeItem(16)) {
            Long stock = this.goodsBatchService.getSumBatchStockBatch(GoodsTypeEnum.DUIBA, item.getId());
            item.setRemaining(Integer.valueOf(stock.toString()));
        }
        return item;
    }

    @Override
    public ItemEntity find(Long id) {
        ItemEntity entity = this.itemDao.find(id);
        if (entity == null) {
            return null;
        }
        if (entity.isOpTypeItem(16)) {
            Long stock = this.goodsBatchService.getSumBatchStockBatch(GoodsTypeEnum.DUIBA, entity.getId());
            entity.setRemaining(Integer.valueOf(stock.toString()));
        }
        return entity;
    }

    @Override
    public ItemEntity findByType(String type) {
        ItemEntity entity = this.itemDao.findByType(type);
        if (entity == null) {
            return null;
        }
        return entity;
    }

    @Override
    public List<ItemEntity> findByIds(List<Long> ids) {
        List<ItemEntity> entitys = this.itemDao.findAllByIds(ids);
        ArrayList<GoodsStockDto> stocks = new ArrayList<GoodsStockDto>();
        for (ItemEntity entity : entitys) {
            if (!entity.isOpTypeItem(16)) continue;
            GoodsStockDto stock = new GoodsStockDto();
            stock.setGid(entity.getId());
            stock.setGtype(GoodsTypeEnum.DUIBA);
            stocks.add(stock);
        }
        if (!stocks.isEmpty()) {
            List<GoodsStockDto> gst = this.goodsCouponBO.findGoodsStockByBatch(stocks);
            HashMap<Long, Long> map = new HashMap<Long, Long>();
            for (GoodsStockDto dto : gst) {
                map.put(dto.getGid(), dto.getStock());
            }
            for (ItemEntity entity : entitys) {
                Long stock = (Long)map.get(entity.getId());
                if (stock == null || !entity.isOpTypeItem(16)) continue;
                entity.setRemaining(Integer.valueOf(stock.toString()));
            }
        }
        return entitys;
    }

    @Override
    public Map<Long, ItemEntity> findByIdsToMap(List<Long> ids) {
        List<ItemEntity> entitys = this.itemDao.findAllByIds(ids);
        ArrayList<GoodsStockDto> stocks = new ArrayList<GoodsStockDto>();
        HashMap<Long, ItemEntity> maps = new HashMap<Long, ItemEntity>();
        for (ItemEntity entity : entitys) {
            maps.put(entity.getId(), entity);
            if (!entity.isOpTypeItem(16)) continue;
            GoodsStockDto stock = new GoodsStockDto();
            stock.setGid(entity.getId());
            stock.setGtype(GoodsTypeEnum.DUIBA);
            stocks.add(stock);
        }
        if (!stocks.isEmpty()) {
            List<GoodsStockDto> gst = this.goodsCouponBO.findGoodsStockByBatch(stocks);
            HashMap<Long, Long> map = new HashMap<Long, Long>();
            for (GoodsStockDto dto : gst) {
                map.put(dto.getGid(), dto.getStock());
            }
            for (ItemEntity entity : entitys) {
                Long stock = (Long)map.get(entity.getId());
                if (stock == null || !entity.isOpTypeItem(16)) continue;
                entity.setRemaining(Integer.valueOf(stock.toString()));
            }
        }
        return maps;
    }

    @Override
    public Long insert(ItemEntity itemEntity) {
        this.itemDao.insert(itemEntity);
        this.eventHomeCache.invalidItem(itemEntity.getId());
        return itemEntity.getId();
    }

    @Override
    public Boolean update(ItemEntity itemEntity) {
        int ret = this.itemDao.update(itemEntity);
        if (ret > 0) {
            this.eventHomeCache.invalidItem(itemEntity.getId());
            this.advancedCacheClient.remove(this.getCacheKeyById(itemEntity.getId()));
            return true;
        }
        return false;
    }

    @Override
    public Boolean delete(Long itemId) {
        int ret = this.itemDao.delete(itemId);
        if (ret > 0) {
            this.eventHomeCache.invalidItem(itemId);
            this.advancedCacheClient.remove(this.getCacheKeyById(itemId));
            return true;
        }
        return false;
    }

    @Override
    public Boolean updateEnable(Long itemId, Boolean enable) {
        int ret = this.itemDao.updateEnable(itemId, enable);
        if (ret > 0) {
            this.eventHomeCache.invalidItem(itemId);
            this.advancedCacheClient.remove(this.getCacheKeyById(itemId));
            return true;
        }
        return false;
    }

    @Override
    public Boolean decrStock(Long itemId) {
        int ret = this.itemDao.decrStock(itemId);
        if (ret > 0) {
            return true;
        }
        return false;
    }

    @Override
    public Boolean incrStock(Long itemId) {
        int ret = this.itemDao.incrStock(itemId);
        if (ret > 0) {
            this.eventHomeCache.invalidItem(itemId);
            this.advancedCacheClient.remove(this.getCacheKeyById(itemId));
            return true;
        }
        return false;
    }

    @Override
    public Boolean appendStock(Long itemId, Long number) {
        int ret = this.itemDao.appendStock(itemId, number);
        if (ret > 0) {
            this.eventHomeCache.invalidItem(itemId);
            this.advancedCacheClient.remove(this.getCacheKeyById(itemId));
            return true;
        }
        return false;
    }

    @Override
    public Boolean deductStock(Long itemId, Long number) {
        int ret = this.itemDao.deductStock(itemId, number);
        if (ret > 0) {
            this.eventHomeCache.invalidItem(itemId);
            this.advancedCacheClient.remove(this.getCacheKeyById(itemId));
            return true;
        }
        return false;
    }

    @Override
    public List<ItemEntity> findAutoRecommend(Long appId) {
        String key = (Object)((Object)RedisKeyFactory.K206) + String.valueOf(appId);
        List cache = (List)this.redisCacheService.getObject((Object)((Object)RedisKeyFactory.K206) + String.valueOf(appId));
        if (cache != null) {
            return cache;
        }
        List<Long> allList = this.itemAutoRecommendDao.findItemAutoRecommendNoSpecify(true, true);
        List<Long> spcefyList = this.itemAutoRecommendDao.findItemSpecify(appId);
        List<Long> appMaskingList = this.appItemMaskDao.findItemAppMasking(appId);
        List<Long> tagsMaskingList = this.itemAutoRecommendDao.findItemAppTagsMasking(appId);
        List<Long> inAppList = this.itemAutoRecommendDao.findItemInApp(appId, false, false);
        List<Long> itemIdList = ListUtils.sum(allList, spcefyList);
        itemIdList = ListUtils.subtract((List)itemIdList, appMaskingList);
        itemIdList = ListUtils.subtract((List)itemIdList, tagsMaskingList);
        if ((itemIdList = ListUtils.subtract((List)itemIdList, inAppList)) != null && itemIdList.size() > 20) {
            itemIdList = itemIdList.subList(0, 20);
        }
        ArrayList<ItemEntity> entitys = new ArrayList();
        if (itemIdList != null && !itemIdList.isEmpty()) {
            entitys = this.findByIds(itemIdList);
        }
        this.redisCacheService.setObject(key, cache, 60);
        return entitys;
    }

    @Override
    public List<ItemEntity> findAutoRecommendMap(Long appId, Map<String, Object> query) {
        query.put("appId", appId);
        query.put("autoRecommend", true);
        query.put("enable", true);
        List<Long> allList = this.itemAutoRecommendDao.findItemAutoRecommendNoSpecifyMap(query);
        List<Long> spcefyList = this.itemAutoRecommendDao.findItemSpecifyMap(query);
        List<Long> appMaskingList = this.appItemMaskDao.findItemAppMasking(appId);
        List<Long> tagsMaskingList = this.itemAutoRecommendDao.findItemAppTagsMasking(appId);
        List<Long> inAppList = this.itemAutoRecommendDao.findItemInApp(appId, false, false);
        List<Long> itemIdList = ListUtils.sum(allList, spcefyList);
        itemIdList = ListUtils.subtract((List)itemIdList, appMaskingList);
        itemIdList = ListUtils.subtract((List)itemIdList, tagsMaskingList);
        itemIdList = ListUtils.subtract((List)itemIdList, inAppList);
        if (itemIdList != null && itemIdList.size() > 20) {
            itemIdList = itemIdList.subList(0, 20);
        }
        List<ItemEntity> entitys = new ArrayList<ItemEntity>();
        if (itemIdList != null && !itemIdList.isEmpty()) {
            entitys = this.findByIds(itemIdList);
        }
        return entitys;
    }

    @Override
    public Boolean isRechargeGoods(ItemEntity entity) {
        if (entity == null) {
            return false;
        }
        if ("alipay".equals(entity.getType())) {
            return true;
        }
        if ("alipaycode".equals(entity.getType())) {
            return true;
        }
        if ("alipayfast".equals(entity.getType())) {
            return true;
        }
        if ("phonebill".equals(entity.getType())) {
            return true;
        }
        if ("phoneflow".equals(entity.getType())) {
            return true;
        }
        if ("qb".equals(entity.getType())) {
            return true;
        }
        return false;
    }

    @Override
    public Long findSpecifyRemaining(Long appId, Long itemId) {
        return this.itemAppSpecifyDao.findSpecifyRemaining(itemId, appId);
    }

    @Override
    public int updateRemainingAndvalidEndDate(Long itemId, Long totalStock, Date validEndDate) {
        int ret = this.itemDao.updateRemainingAndvalidEndDate(itemId, totalStock, validEndDate);
        this.eventHomeCache.invalidItem(itemId);
        this.advancedCacheClient.remove(this.getCacheKeyById(itemId));
        return ret;
    }

    @Override
    public List<ItemDto> findHomeItems(List<Long> itemIds) {
        return this.itemDao.findHomeItems(itemIds);
    }

    @Override
    public void removeCache(Long itemId) {
        try {
            this.eventHomeCache.invalidItem(itemId);
            this.advancedCacheClient.remove(this.getCacheKeyById(itemId));
        }
        catch (Exception e) {
            LOGGER.error("removeCache:itemId=" + itemId, (Throwable)e);
        }
    }

    @Override
    public String getJsonValue(Long id, String key) {
        return this.itemDao.getJsonValue(id, key);
    }

    @Override
    public Integer setJsonValue(Long id, String key, String value) {
        if (StringUtils.isBlank((String)key)) {
            throw new RuntimeGoodsException(ErrorCode.E0404004);
        }
        TransactionStatus status = this.creditsTransactionManager.getTransaction((TransactionDefinition)new DefaultTransactionDefinition());
        int ret = 0;
        try {
            String jsonText = this.itemDao.findJson4Update(id);
            JSONObject json = StringUtils.isBlank((String)jsonText) ? new JSONObject() : JSONObject.parseObject((String)jsonText);
            if (StringUtils.isEmpty((String)value) && StringUtils.isNotEmpty((String)json.getString(key))) {
                json.remove((Object)key);
            }
            if (null != value) {
                json.put(key, (Object)value);
            }
            ret = this.itemDao.setJsonValue(id, json.toJSONString());
        }
        catch (Exception e) {
            status.setRollbackOnly();
            throw e;
        }
        finally {
            this.creditsTransactionManager.commit(status);
        }
        this.advancedCacheClient.remove(this.getCacheKeyById(id));
        return ret;
    }
}

