/**
 * Project Name:goods-center-common File Name:GoodsException.java Package Name:cn.com.duiba.goods.center.common
 * Date:2016年5月25日下午1:33:07 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.goods.center.common;

/**
 * 内部异常 <功能详细描述>.
 * 
 * @author: xuhengfei
 * @version:
 */
public class GoodsException extends Exception {

    /** The Constant serialVersionUID. */
    private static final long serialVersionUID = 4488920747852502701L;

    /** The result code. */
    private String            resultCode       = "0";

    /** The result message. */
    private String            resultMessage    = "Success";

    private ErrorCode         errorCode;
    /**
     * The Constructor.
     */
    public GoodsException() {
        super();
    }

    /**
     * The Constructor.
     * 
     * @param code the code
     */
    public GoodsException(ErrorCode code) {
        super(code.getDesc());
        this.errorCode=code;
        this.resultCode = code.getErrorCode();
        this.resultMessage = code.getDesc();
    }

    /**
     * Creates a new instance of GoodsException.
     *
     * @param resultCode
     * @param resultMessage
     */
    
    public GoodsException(String resultCode, String resultMessage) {
        super(resultMessage);
        this.resultCode = resultCode;
        this.resultMessage = resultMessage;
    }

    /**
     * The Constructor.
     * 
     * @param code the code
     * @param cause the cause
     */
    public GoodsException(ErrorCode code, Throwable cause) {
        super(cause);
        this.errorCode=code;
        this.resultCode = code.getErrorCode();
        this.resultMessage = code.getDesc();
    }


    /**
     * Gets the result code.
     * 
     * @return the resultCode
     */
    public String getResultCode() {
        return resultCode;
    }

    /**
     * Sets the result code.
     * 
     * @param resultCode the resultCode to set
     */
    public void setResultCode(String resultCode) {
        this.resultCode = resultCode;
    }

    /**
     * Gets the result message.
     * 
     * @return the resultMessage
     */
    public String getResultMessage() {
        return resultMessage;
    }

    /**
     * Sets the result message.
     * 
     * @param resultMessage the resultMessage to set
     */
    public void setResultMessage(String resultMessage) {
        this.resultMessage = resultMessage;
    }

    /**
     * 自定义toString
     * 
     * @return the string
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("GoodsException [resultCode=");
        builder.append(resultCode);
        builder.append(", resultMessage=");
        builder.append(resultMessage);
        builder.append("]");
        return builder.toString();
    }

    
    public ErrorCode getErrorCode() {
        return errorCode;
    }

}
