/**
 * Project Name:goods-center-common
 * File Name:RedisKeyTool.java
 * Package Name:cn.com.duiba.goods.center.common
 * Date:2016年6月4日下午8:46:35
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.common;

/**
 * ClassName:RedisKeyTool <br/>
 * Function: Redis生成Key的工具. <br/>
 * Date:     2016年6月4日 下午8:46:35 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public class RedisKeyTool {
    
    public static String getRedisKey(Class<?> clazz,String kind,String bizKey){
        return "goods-"+clazz.getSimpleName()+"-"+kind+"-"+bizKey;
    }
    
    /***品牌商品关联表key 参数：sellerId*/
    public static String getSellerGoodsRedisKey(String bizKey){
    	return "sellerGoodss-"+bizKey;
    }
    
    /***平台券key 参数：pcgId*/
    public static String getPlatformRedisKey(String bizKey){
    	return "platform-"+bizKey;
    }
    
    /***预分配key 参数：pcgId-appId*/
    public static String getDirectionalRedisKey(String bizKey){
    	return "directional-"+bizKey;
    }
    
    /***商品、品牌、类别key 参数：appId-targetType*/
    public static String getFilterConfigRedisKey(String bizKey){
    	return "filterConfig-"+bizKey;
    }
    
    /***类别商品关联key 参数：categoryId*/
	public static String getCategoryGoodsRedisKey(String bizKey) {
		return "categoryGoodss-"+bizKey;
	}
	
	public static String getCategoryRedisKey() {
		return "category";
	}
	
	public static String getSellerRedisKey() {
		return "seller";
	}
    
}

