/**
 * 
 */
package cn.com.duiba.goods.center.common;

/**
 * 此类描述的是： 项目错误码<br>
 * 错误码组成：AABBCCC
 * <ul>
 * AA：模块编号
 * <li>01：平台券商品模块</li>
 * <li>02：券码库模块(批次和券码)</li>
 * </ul>
 * <ul>
 * BB：错误类型
 * <li>01 - 应用级错误（前端参数错误）</li>
 * <li>02 - 业务级错误（service自身错误）</li>
 * <li>03 - 依赖级错误（service调用第三方服务错误）  </li>
 * <li>04 - 交互级业务提醒（正常业务逻辑，非错误，需告知用户，如库存不足）  </li>
 * </ul>
 * <ul>
 * <ul>
 * CCC:具体错误码 举例
 * <li>通用的成功状态码：0000000</li>
 * <li>通用的未知错误码：9999999</li>
 * </ul>
 * .
 * @see http://cf.dui88.com/pages/viewpage.action?pageId=3544570
 * @version: 2016年2月18日 下午3:36:01
 */
public enum ErrorCode {

    /** 成功. */
    E0000000("000000", "成功"),
    //平台券商品模块
    /** 数据库异常. */
    E0102001("0102001", "数据库异常"),
    E0102002("0102002", "更新失败"),

    //券码库模块
    /** Redis异常. */
    E0202002("0202002", "Redis异常"),
    /** 重试次数过多 */
    E0202003("0202003","重试次数过多"),
    /** 获取锁失败 */
    E0202004("0202004","获取锁失败"),
    /** 批次下的券码已售罄 */
    E0202005("0202005","批次下的券码已售罄"),
    /** 商品库存不足 */
    E0202006("0202006","商品库存不足"),
    E0202007("0202007","超出限制"),
    E0202008("0202008","不存在的类型"),
    E0202009("E0202009","预分配库存不存在"),

    /** Dubbo获取券码id出错 */
    E0203001("0203001","Dubbo获取券码id出错"),
    /** Dubbo获取商品id出错 */
    E0203002("0203002","Dubbo获取商品id出错"),
    
    /** Dubbo 库存中心异常 */
    E0203003("0203003","Dubbo 库存中心异常"),
    
    /** 创建批次异常 */
    E0404001("0404001","批次已存在"),

    /** 未知错误. */
    E9999999("9999999", "发生系统未知错误");

    /** 错误码. */
    private String errorCode;

    /** 中文描述. */
    private String desc;

    /**
     * The Constructor.
     *
     * @param errorCode the error code
     * @param desc the desc
     */
    private ErrorCode(String errorCode, String desc) {
        this.errorCode ="GC-"+ errorCode;
        this.desc = desc;
    }

    /**
     * The Constructor.
     *
     * @param errorCode the error code
     */
    private ErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    /**
     * Gets the error code.
     *
     * @return the error code
     */
    public String getErrorCode() {
        return errorCode;
    }

    /**
     * Gets the desc.
     *
     * @return the desc
     */
    public String getDesc() {
        return desc;
    }

}
