/**
 * Project Name:goods-center-common
 * File Name:MemcacheKeyEnum.java
 * Package Name:cn.com.duiba.goods.center.common
 * Date:2016年5月25日下午2:51:10
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.goods.center.common;

/**
 * ClassName:MemcacheKeyEnum <br/>
 * Function: Memcache Key统一维护 <br/>
 * Date:     2016年5月25日 下午2:51:10 <br/>
 * @author   xuhengfei
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public enum MemcacheKeyEnum {
    /** 批次的剩余库存 */
    K0001("K0001","批次的剩余库存"),
    K0002("K0002","自动推荐商品");
    
    private String key;
    private String description;
    
    private MemcacheKeyEnum(String key,String description){
        this.key="goods-"+key+"-";
        this.description=description;
    }
    
    public String getKey() {
        return key;
    }

    
    public String getDescription() {
        return description;
    }
}

