package cn.com.duiba.goods.common.dto;

import cn.com.duiba.goods.common.enums.ScrollingType;

import java.io.Serializable;

/**
 * 瀑布流分页list
 * Created by guoyanfei .
 * 2022/12/28 .
 */
public class ScrollingPageRequest implements Serializable {

    private static final long serialVersionUID = -3910288654277404541L;

    /**
     * 分页查询，默认每页数量
     */
    private static final int DEFAULT_PAGE_SIZE = 100;

    /**
     * 排序类型
     * {@link ScrollingType}
     */
    private Integer scrollingType;

    /**
     * 边界值
     */
    private Long boundaryValue;

    /**
     * 每页条数
     */
    private Integer pageSize = DEFAULT_PAGE_SIZE;

    public ScrollingPageRequest() {
    }

    public ScrollingPageRequest(Integer scrollingType, Integer pageSize) {
        this.scrollingType = scrollingType;
        this.pageSize = pageSize;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Integer getScrollingType() {
        return scrollingType;
    }

    public void setScrollingType(Integer scrollingType) {
        this.scrollingType = scrollingType;
    }

    public Long getBoundaryValue() {
        return boundaryValue;
    }

    public void setBoundaryValue(Long boundaryValue) {
        this.boundaryValue = boundaryValue;
    }
}
