package cn.com.duiba.goods.common.enums;

import cn.com.duiba.goods.common.exception.EnumNotFoundException;

/**
 * 逻辑删除枚举
 * Created by guoyanfei .
 * 2022/11/7 .
 */
public enum DeleteFlagEnum implements BaseEnum {

    NOT_DELETED(0, "未删除"),
    DELETED(1, "已删除");

    private final int code;

    private final String desc;

    DeleteFlagEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public int code() {
        return code;
    }

    @Override
    public String desc() {
        return desc;
    }

    public static DeleteFlagEnum getByCode(int code) {
        for (DeleteFlagEnum it : DeleteFlagEnum.values()) {
            if (it.code() == code) {
                return it;
            }
        }
        throw new EnumNotFoundException(code, "DeleteFlagEnum");
    }

}
